# Tiempo total

Escribe una función llamada `tiempototal`. Dicha función recibirá como
único parámetro una lista de tuplas. Cada tupla tendrá dos elementos: el
primero será una cadena de caracteres y el segundo, un número entero. La
función deberá devolver un diccionario cuyas claves serán cadenas de
caracteres y cuyos valores serán números enteros.

En el contexto de una tienda online, estamos interesados en controlar
cuánto tiempo pasan los usuarios en cada página de producto. Mediante el
uso de cookies, es posible rastrear exactamente cuánto tiempo pasa cada
usuario en cada página de un sitio web.

Cada elemento de la lista que recibe como entrada la función representa
el tiempo que ha pasado un usuario determinado en una página de
producto. El nombre del producto es el primer elemento de la tupla y el
tiempo en segundos que ha padado el usuario en esa página es el segundo
elemento.

Las claves del diccionario devuelto por la función se corresponderán con
los nombres de producto que se encuentran en la lista de entrada,
mientras que los valores representarán el tiempo total (en segundos) que
todos los usuarios del sitio web han pasado en la página del producto
correspondiente a la clave.

Por ejemplo, para la lista de entrada @\[ (\"cafetera Delonghi\",15),
(\"granos Robusta\",4), (\"cafetera Delonghi\",9), (\"cafetera
Delonghi\",8) \]@, el programa deberá devolver el diccionario
{@\"cafetera Delonghi\": 32 , \"granos Robusta\": 4@}. Ten en cuenta que
el orden de las claves en un diccionario es irrelevante, así que no te
preocupes si, al imprimir el diccionario producido por tu función,
obtienes {@\"granos Robusta\": 4 , \"cafetera Delonghi\": 32@}.

Si se recibe como entrada una lista vacía, la función deberá devolver un
diccionario vacío.

Para que tu función pueda ser evaluada correctamente por el juez en
línea, tu código deberá tener la siguiente forma:

``` python
import sys

def tiempototal(l):
...

l=eval(sys.stdin.readline().strip())
resultado=tiempototal(l)
print( "+".join( sorted([ k+":"+str(resultado[k])  for k in resultado ]) )  )
```

## Entrada

(Si utilizas el fragmento de código definido más arriba, no debes
preocuparte por esto) Una línea que contendrá la lista escrita en una
sola línea como si se tratara de código fuente Python.

## Salida

(Si utilizas el fragmento de código definido más arriba, no debes
preocuparte por esto) El contenido del diccionario en una sola línea.
Cada elemento del diccionario estará separado por el carácter `+`. Clave
y valor estarán separados por dos puntos. Los elementos estarán
ordenados alfabéticamente.

## Información del problema

Autoría: Víctor M. Sánchez Cartagena

Generación: 2026-01-25T18:38:26.653Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
