# Arbre general. Són els elements del recorregut en preordre especular una seqüència estrictament creixent?

Donada la classe $Arbre$ que permet gestionar arbres generals usant
memòria dinàmica, cal implementar el mètode

      bool preordre_especular_creixent();

que determina si els elements del recorregut en preodre especular de
l'arbre (o sigui, un recorregut en preodre on els fills es visiten de
dreta a esquerra) són una seqüència d'enters estrictament creixent.
Considerem que una seqüència buida es estrictament creixent.

Cal enviar a jutge.org la següent especificació de la classe $Arbre$ i
la implementació del mètode dins del mateix fitxer.

    #include <iostream>
    #include <cstdlib>
    using namespace std;
    typedef unsigned int nat;

    template <typename T>
    class Arbre {

    public:
      // Construeix un Arbre format per un únic node que conté a x.
      Arbre(const T &x);

      // Tres grans.
      Arbre(const Arbre<T> &a);
      Arbre& operator=(const Arbre<T> &a);
      ~Arbre() throw();

      // Col·loca l'Arbre donat com a darrer fill de l'arrel de l'arbre sobre el que s'aplica el mètode i l'arbre a queda invalidat; després de fer b.afegir\_fill(a), a no és un arbre vàlid.
      void afegir_darrer_fill(Arbre<T> &a);

      static const int ArbreInvalid = 400;

      //Comprova si els elements del recorregut en preodre especular de l’arbre 
      //(o sigui, un recorregut en preodre on els fills es visiten de dreta a 
      //esquerra) són una seqüència d'enters estrictament creixent.
      bool preordre_especular_creixent();

    private:
      Arbre(): _arrel(NULL) {};
      struct node {
        T info;
        node* primf;
        node* seggerm;
      };
      node* _arrel;
      static node* copia_arbre(node* p);
      static void destrueix_arbre(node* p) throw();

      // Aquí va l'especificació dels mètodes privats addicionals
    };

    // Aquí va la implementació del mètode preordre\_especular\_creixent

Per testejar la solució, jutge.org ja té implementats la resta de
mètodes de la classe $Arbre$ i un programa principal que llegeix un
arbre general i crida el mètode $preordre\_especular\_creixent$.

## Entrada

L'entrada consisteix en la descripció d'un arbre general d'enters (el
seu recorregut en preordre, en el qual al valor de cada node li segueix
el seu nombre de fills).

## Sortida

Una línia amb el text \"NO es estrictament creixent\" si es dona el cas
que els elements del recorregut en preodre especular de l'arbre (o
sigui, un recorregut en preodre on els fills es visiten de dreta a
esquerra) no són una seqüència d'enters estrictament creixent. La
sortida serà, \"SI es estrictament creixent\" altrament.

## Observació

Només cal enviar la classe requerida i la implementació del mètode
$preordre\_especular\_creixent$. Pots ampliar la classe amb mètodes
privats. Segueix estrictament la definició de la classe de l'enunciat.

::: multicols
2

## Exemple d'entrada sample-1

## Exemple de sortida sample-1
:::

::: multicols
2

## Exemple d'entrada sample-2

## Exemple de sortida sample-2
:::

::: multicols
2

## Exemple d'entrada sample-3

## Exemple de sortida sample-3
:::

::: multicols
2

## Exemple d'entrada sample-4

## Exemple de sortida sample-4
:::

::: multicols
2

## Exemple d'entrada sample-5

## Exemple de sortida sample-5
:::

::: multicols
2

## Exemple d'entrada sample-6

## Exemple de sortida sample-6
:::

## Informació del problema

Autoria: Ignasi Gómez-Sebastià

Generació: 2026-01-25T13:27:44.222Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
