# Esborrat de totes les aparicions d'un element a una llista

Considerem la representació habitual amb nodes de la classe *Llista* per
manegar llistes genèriques d'elements de tipus **T** que podeu trobar
als fitxers publics.

Els nodes són doblement encadenats amb punters al següent (**seg**) i a
l'anterior (**ant**). Una llista té quatre atributs; la **longitud** i
tres punters a nodes, un pel primer element (**primer_node**), un per
l'ultim (**ultim_node**) i un altre per l'element actual (**act**), on
tenim situat el punt d'interès de la llista.

Recordeu que si l'**act** d'una llista no buida té valor **null**
significa que el punt d'interès està situat a la dreta de tot, a sobre
d'un element fictici posterior a l'últim element real.

Volem implementar dins d'aquesta classe una operació nova amb la següent
especificació pre/post:

    void esborrar_tots(const T& x) 
    /* Pre: parametre implicit = P */
    /* Post: s'han eliminat del parametre implicit totes les aparicions d'x (la
       resta d'elements queda en el mateix ordre que a P); si el punt d'interes de P 
       referenciava a una aparicio d'x, passa a referenciar al primer element 
       diferent d'x posterior a aquesta (si no hi ha cap element diferent d'x, passa
       a la dreta el tot); en cas contrari, el punt d'interes no canvia */

Exemples:

Si $x = 5$ i el paràmetre implícit es

    1   3   5   7   12   5   5   5   25

amb el punt d'interes sobre el 7, llavors el nou paràmetre implícit ha
de quedar

    1   3   7   12   25

amb el punt d'interès sobre el 7.

Si $x=5$ i el paràmetre implícit és

    1   3   5   7   12   5   5   5   5

amb el punt d'interès sobre el penúltim 5, llavors el nou paràmetre
implícit ha de quedar

    1   3   7   12

amb el punt d'interès a la dreta del tot.

Dissenyeu aquesta operació sense utilitzar cap de les operacions
primitives de les llistes, accedint directament als atributs de la
classe **Llista**.

## Entrada

L'entrada es una llista y un element $x$.

## Sortida

La sortida es la llista obtinguda després d'haver eliminat de la llista
d'entrada tots els nodes que contenien l'element $x$. A més a més, el
punter **act** ha de seguir apuntant al mateix element al que apuntava
abans de cridar el mètode o, si referenciava a un node que contenia $x$,
ha d'apuntar al següent element (si n'hi ha) o a la dreta del tot (si no
n'hi ha). Enrecordeu-vos d'actualitzar la longitud de la llista i de
esborrar correctament tots els elements amb l'operador *delete*, d'altra
banda el resultat no serà acceptat pel Jutge.

## Observació

Només s'ha d'enviar un fitxer que contengui la funció amb la capçalera
de l'enunciat i qualsevol altra funció auxiliar que cregueu convenient,
sense la funció main i sense posar-hi cap "include".

## Informació del problema

Autoria: Alberto Moreno (adaptador), Ramon Ferrer i Cancho (responsable)

Generació: 2026-01-27T18:50:34.290Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
