# Sequential adder

Design a circuit that calculates the addition of two numbers
sequentially. The circuit has two inputs, `a` and `b` that provide one
binary digit at each cycle (starting from the least-significant bits).
At each cycle, the circuit produces a binary digit of the addition.

Here is an example of a sequence of cycles (note that time moves from
right to left):

      cycle:    ... 7 6 5 4 3 2 1 0
      -----------------------------
      a:        ... 1 0 0 1 1 0 1 0
      b:        ... 0 0 0 1 0 1 1 1
      -----------------------------
      sum:      ... 1 0 1 1 0 0 0 1

## Specification

``` verilog
module sequential_adder (a, b, sum, clk, rst);
    input a, b, clk, rst;
    output sum;
```

## Input

- `a` and `b` are the two sequential inputs.

- `clk` is the clock signal.

- `rst` is the reset signal.

## Output

- `sum` generates the addition of `a`and `b` sequentially.

## Problem information

Author: Jordi Cortadella

Generation: 2026-01-25T13:26:00.481Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
