# Amphitheatre

Measharans like to attend plays and concerts which take place in
amphitheatres. Artists perform on a stage, which is a semicircle of
radius $r$ meters. Guests take their places in rows, which are
concentric semicircles around the stage; $i$-th row has a radius of
$r+(i-1)$ meters. Each row is divided into $d$ equal sectors.

![image](amphi){width="7cm"}

It is possible to move in two ways: move along a row (clockwise or
counter-clockwise), at a speed of $v_r$ meters per minute; or along one
of $d+1$ sector boundaries, at a speed of $v_d$ (downwards, i.e.,
towards the stage) or $v_u$ (upwards) meters per minute.

The amphitheatres are planning to create an online system for booking
seats. However, when booking for a group, it is sometimes impossible to
make all the group sit together, but it is important to make it easy for
the group members to reach each other. Your task is to calculate the
time required to travel between two given seats.

## Input

Input consists of several cases. Each case is a single line containing
nine integers: $r$ (radius of the stage), $d$ (number of sectors),
$v_r$, $v_d$, $v_u$ (speeds, as defined above), $s_1$ (the row number of
the first seat), $\phi_1$ (the position of the first seat on the
semicircle, given in degrees), $s_2$, $\phi_2$ (row number and position
of the second seat). We have $1 \leq r \leq 1000$, $1 \leq d \leq 1000$,
$1 \leq v_r, v_d, v_u \leq 100$, $1 \leq s_1,s_2 \leq 1000$,
$0 \leq \phi_1, \phi_2 \leq 180$.

Input ends with a line containing 9 zeros.

## Output

For each input case output a single number -- the number of minutes
required to travel from the first seat to the second seat, rounded to
exactly three decimal places.

In the first case, we need to traverse the whole first row, which is a
semicircle of radius 100. The speed is 3 m/min, so we need $100\pi/3$
minutes.

In the secord case, we are sitting at a sector boundary, so it is enough
to climb 10 meters at speed 5 m/min. The third case is similar, except
that we are descending now.

In the fourth case, we are not able to climb directly, since we are not
sitting at a degree boundary. We need to go 5 degrees to the sector
boundary (at 75 degrees), climb 1 meter, and go 5 degrees back.

The last two cases return very small values.

## Problem information

Author: Eryk Kopczynski

Generation: 2026-01-25T13:23:10.502Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
