# Bus invert

Design a circuit that transfers or inverts the value of an $N$-bit bus.
A control signal called `invert` will determine whether the value must
be transferred (`invert`=0) or inverted (`invert`=1). $N$ must be a
parameter of the circuit with default value 8.

## Specification

``` verilog
module bus_transfer_invert(in, invert, out);
    parameter N=8;
    input [N-1:0] in;
    input invert;
    output [N-1:0] out;
```

## Input

- `in` is the $N$-bit input bus.

- `invert` is the control signal that determines whether the value of
  the bus must be transferred or inverted.

## Output

- `out` is the $N$-bit inverted value of the bus.

## Problem information

Author: Jordi Cortadella

Generation: 2026-02-03T12:14:39.993Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
