#include <iostream>
#include <string>
#include <list>
#include <sstream>

using namespace std;

void comprimir(const list<int> &l, list<pair<int,int>> &res);

#ifndef IOLISTFUNCTIONS
#define IOLISTFUNCTIONS

void readList(const string &line, list<int> &l) {
	istringstream mycin(line);
	int x;
	while (mycin >> x) {
		l.push_back(x);
	}
}

template <typename T>
void print(T t) {
}

template <>
void print<int>(int x) {
	cout << x;
}

template <>
void print<pair<int,int>>(pair<int,int> x) {
	cout << '<' << x.first << ',' << x.second << '>';
}

//~ template <typename T>
//~ void writeListRec(list<T>::const_iterator it, list<T>::const_iterator end) {
	//~ if (it != end) {
		//~ cout << ", ";
		//~ print(*it);
		//~ writeListRec(++it, end);
	//~ }
//~ }

//~ template <typename T>
//~ void writeList(const list<T> &l) {
	//~ if (l.empty()) {
		//~ cout << "[]" << endl;
	//~ }
	//~ else {
		//~ cout << '[';
		//~ print(*l.begin());
		//~ writeListRec(++l.begin(), l.end());
		//~ cout << ']' << endl;
	//~ }
//~ }


void writeListRec(list<int>::const_iterator it, list<int>::const_iterator end) {
	if (it != end) {
		cout << ", " << *it;
		writeListRec(++it, end);
	}
}

void writeList(const list<int> &l) {
	if (l.empty()) {
		cout << "[]" << endl;
	}
	else {
		cout << '[' << (*l.begin());
		writeListRec(++l.begin(), l.end());
		cout << ']' << endl;
	}
}

void writeListRec(list<pair<int,int>>::const_iterator it, list<pair<int,int>>::const_iterator end) {
	if (it != end) {
		cout << ", " << '<' << (*it).first << ',' << (*it).second << '>';
		writeListRec(++it, end);
	}
}

void writeList(const list<pair<int,int>> &l) {
	if (l.empty()) {
		cout << "[]" << endl;
	}
	else {
		cout << '[';
		print(*l.begin());
		writeListRec(++l.begin(), l.end());
		cout << ']' << endl;
	}
}

#endif

int main() {
	string lin;
	while (getline(cin, lin)) {
		int i1 = lin.find('[');
		int i2 = lin.find(']', i1+1);
		string s = lin.substr(i1+1, i2-i1-1);

		list<int> la;
		readList(s, la);
		
		list<pair<int,int>> res;
		comprimir(la, res);
		writeList(res);
	}	
	return 0;
}
