# Daus trucats

Els daus, pel joc, s'han utilitzat des de l'antiguitat i actualment
encara s'utilitzen. També fa molt de temps que existeix l'astúcia dels
tramposos que trucaven aquests daus. Avui en dia hi ha daus de moltes
formes, per exemple daus de 4 cares amb forma piramidal, daus de 12
cares amb forma de dodecaedre, entre molts d'altres. Una forma per
detectar si un dau està trucat és mitjançant l'estadística: si un dau és
just, les cares haurien d'aparèixer amb una freqüència similar quan es
fan moltes tirades.

Un test senzill per detectar si un dau pot estar trucat és comparar les
freqüències relatives de cada cara amb la que s'esperaria si el dau fos
just. En un dau just de $n$ cares, totes les cares tenen la mateixa
probabilitat: $1/n$, o el que és el mateix, un percentatge esperat de
$100/n \%$.

La idea seria calcular el percentatge d'aparicions de cada cara i
comprovar si alguna s'allunya massa del valor esperat ($100/n$). Si hi
ha una desviació superior a un cert llindar (per exemple, $5\%$), es
podria sospitar que el dau està trucat.

Implementa un programa que donat:

- un natural $n>0$ que indica el nombre de cares del dau

- un real positiu corresponent a un cert llindar (%)

- un flux de naturals acabat en 0 que representa les tirades usant
  aquest dau

mostri el percentatge d'aparició de cada número del dau, i faci el test
per indicar si el dau és trucat o no.

**Exemple**:

Donat el flux `1, 4, 4, 2, 3, 2, 4, 3, 0` que són tirades d'un dau de 4
cares i un llindar del $10\%$ el resultat seria:

    Cara 1: 12.5%
    Cara 2: 25%
    Cara 3: 25%
    Cara 4: 37.5%
    TRUCAT

Està trucat ja que per exemple la cara 1 en aplicar el test s'obté que
$25 - 12.5 > 10$.

## Entrada

L'entrada consisteix en:

- un natural $n >0$ (el nombre de cares del dau)

- un real positiu (el llindar de desviació permès)

- una flux de naturals dins del rang $[1..n]$ acabat en 0 (les tirades
  usant aquest dau)

## Sortida

Mostra per cada cara del dau el percentatge d'aparició seguint aquest
format:

    Cara 1: X
    Cara 2: Y
    ...

On X, Y, ...són els percentatges corresponents a cada cara del dau.

I al final, s'ha d'escriure una línia amb el text "`TRUCAT`" o
"`NO TRUCAT`" depenent de si el test dona que el dau està trucat o no.

Per obtenir més detalls sobre la sortida consulta els jocs de proves
públics.

## Informació del problema

Autoria: Bernardino Casas

Generació: 2026-01-25T13:20:22.483Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
