# Dependències Ordenades

Sigui una matriu $n \times m$ d'enters. Aquesta matriu representa una
*taula* de dades de $n$ files i $m$ columnes ($n \geq 2$ i $m \geq 2$).

Diem que la **dependencia ordenada** `x -> y` entre les columnes `x` i
`y`, és **vàlida** a la matriu `M` si i només si per a **tot parell** de
files `i` i `j` (on $i < j$) passa això:

::: center
*l'ordre que tenen els valors a la columna `x` a totes dues files `i` i
`j` és igual a l'ordre que tenen els valors a la columna `y`*.
:::

on la relació d'ordre pot ser $\leq$ o $\geq$. Dit altrament: una
dependència ordenada `x -> y` és vàlida si i només si per a qualsevol
parell de files `i,j` de `M` passa una d'aquestes dues coses:

1.  Si el valor que la fila `i` té a la columna `x` és més gran o igual
    que el valor que la fila `j` té a la columna `x`, aleshores el valor
    que la fila `i` té a la columna `y` sigui més gran o igual que el
    valor que la fila `j` té a la columna `y`.

    o el simètric:

2.  Si el valor que la fila `i` té a la columna `x` és més petit o igual
    que el valor que la fila `j` té a la columna `x`, aleshores el valor
    que la fila `i` té a la columna `y` sigui més petit o igual que el
    valor que la fila `j` té a la columna `y`.

Per exemple, sigui la taula (matriu) `M` de 5 files i 4 columnes:

::: center
  --- --- --- ---
   1   2   2   1
   1   3   2   2
   2   3   3   1
   3   5   4   2
   2   4   5   1
  --- --- --- ---
:::

Considerem la dependència ordenada `0 -> 1`. Veiem que els valors de la
columna `0` a les files 0 i 1 tenen aquesta relació d'ordre: $1 \leq 1$,
que es la mateixa que tenen els valors a la columna `1`: $2 \leq 3$

::: center
   **1**   **2**   2   1
  ------- ------- --- ---
   **1**   **3**   2   2
:::

i també, per exemple, en les files 3 i 4, on tenim $3 \geq 2$ i
$5 \geq 4$:

::: center
   **3**   **5**   4   2
  ------- ------- --- ---
   **2**   **4**   5   1
:::

I veiem que en tots dos casos els valors de la columna `1` compleixen la
mateixa relació d'ordre. I això passa per a **tot** parell de files. Per
tant, la dependència ordenada `0 -> 1` és vàlida a `M`.

En canvi, la dependència ordenada `0 -> 3` **no** és vàlida perquè, per
exemple, a les files 1 i 2 els valors de la columna `0` tenen aquesta
relació: $1 \leq 2$ i els de la columna `3` aquesta: $2 \geq 1$

::: center
   **1**   3   2   **2**
  ------- --- --- -------
   **2**   3   3   **1**
:::

En aquest cas, podem dir que les files 1 i 2 **invaliden** `0 -> 3`.

Fes una funció `dependencia_ordenada` amb la següent declaració i
especificació:

    /*
     * PRE:  M.size() > 0 and M[0].size() > 0 and and 0 <= x,y < M[0].size().
     *
     * POST: Retorna true si i només si la dependència ordenada x -> y
     * 		 és vàlida a la matriu M.        
     */
    bool dependencia_ordenada(const Matriu& M, int x, int y);

## Observació

**Només** cal enviar la funció que us demanem (i les funcions que hagueu
pogut declarat vosaltres).

A més, al fitxer que envieu **cal** que també hi hagi això:

    #include <iostream>
    #include <vector>
    using namespace std;

    typedef vector <int>   Vector;
    typedef vector<Vector> Matriu;

No es pot fer servir l'ordenació del `C++`: `std::sort`. Tampoc no es
pot fer servir el mètode `push_back()` de la classe `vector`.

Si voleu, podeu fer servir les funcions `min`, `max` o `swap`.

Cal tenir en compte que la relació de relació entre dues files `i` i `j`
respecte a la dependència `x -> y` és **simètrica**. És a dir, si el
parell de files `i` i `j` no invalida la dependència `x -> y`, el parell
`j` i `i` tampoc. Per això a la definició de la dependència especifiquem
$i < j$.

## Entrada

L'entrada és una matriu i una seqüència de dependències ordenades. De la
lectura ja se n'encarrega el programa principal.

## Sortida

La sortida són els resultats per a cada dependència ordenada. De
l'escriptura també se n'encarrega el programa principal.

## Informació del problema

Autoria: PRO1

Generació: 2026-01-25T13:18:18.245Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
