#include <cassert>
#include <iostream>
#include <vector>

using namespace std;

typedef vector <int>   Vector;
typedef vector<Vector> Matriu;

/*
 * PRE:  M.size() > 0 and M[0].size() > 0 and 0 <= x,y < M[0].size().
 *
 * POST: Retorna true si i només si la dependència funcional x -> y
 * 		 és vàlida a la matriu M.        
 */
bool dependencia_funcional(const Matriu& M, int x, int y);

void llegeix_matriu(Matriu& M, int f, int c)
{
	assert(M.size() > 0);
	assert(M.size() == f and M[0].size() == c);
	
	for (int i = 0 ; i < f ; i++)
		for (int j = 0 ; j < c ; j++)
			cin >> M[i][j];

	return;
}

void escriu_matriu(const Matriu& M)
{
	assert(M.size() > 0);
	int f = M.size();
	int c = M[0].size();
	
	for (int i = 0 ; i < f ; i++)
	{
		for (int j = 0 ; j < c ; j++)
			cout << M[i][j] << " ";
		cout << endl;
	}
	return;
}

int main() 
{
	
	int f,c;
	cin >> f >> c;
	
	Matriu M(f,Vector(c,0));

	llegeix_matriu(M,f,c);
//	escriu_matriu(M);

	int x,y;
	string fletxa;
	
	while (cin >> x >> fletxa >> y)
	{
		bool b = dependencia_funcional(M,x,y);
		cout << x << fletxa << y << " " << (b ? "SI" : "NO") << endl;
	}

	return 0;
}
