from pytokr import pytokr
item, items = pytokr(iter=True)

#------------------------------------------------------------------

class Llista:

    # ----------------------------------------------------
    # Classe interna per definir els elements de la llista:
    # Cada element de la llista serà una instància de _Node
    class _Node:
        __slots__ = '_element','_next','_prev' # opcional, per eficiència
        
        def __init__(self, prev, next, element=None): 
            self._element = element            # ref. a l'element emmagatzemat
            self._next = next                  # referència al proper node
            self._prev = prev                  # referència al node anterior 
    # ----------------------------------------------------
            
    def __init__(self):
        self._sentinella = self._Node(None,None)   # _Node sentinella
        self._sentinella._next = self._sentinella
        self._sentinella._prev = self._sentinella
        self._cursor   = self._sentinella
        self._n        = 0                    # nombre d'elements (sense sentinella!)

    def mida(self):                         
        return self._n

    def buida(self):
        return self._n == 0

    # Comprova si el cursor és al principi
    # de la llista 
    def principi(self):
        return self._cursor == self._sentinella._next
  
    # Comprova si el cursor és al final
    # de la llista    
    def final(self):
        return self._cursor == self._sentinella

    # Mou el cursor una posició enrere
    def enrere(self):
        # Pre: el cursor NO està al començament
        assert not self.principi() 
        self._cursor = self._cursor._prev

    # Mou el cursor una posició endavant   
    def endavant(self):
        # Pre: el cursor NO està al final
        assert not self.final()
        self._cursor = self._cursor._next

    # Mou el cursor al principi de la llista
    def anar_al_principi(self):
        self._cursor = self._sentinella._next

    # Mou el cursor al final de la llista 
    def anar_al_final(self):
        self._cursor = self._sentinella # !!!

    # Retorna l'element referenciat pel cursor
    def element(self):
        # Pre: el cursor NO està al final
        assert not self.final()
        return self._cursor._element

    # Insereix l'element x abans del cursor
    def inserir(self, x):
        p = self._Node(self._cursor._prev, self._cursor, x)
        self._cursor._prev._next = p
        self._cursor._prev = p
        self._n += 1
        return self

    # Elimina l'element ref. pel cursor
    # i avança el cursor una posició
    def eliminar(self):
        # Pre: el cursor NO està al final
        assert not self.final()
        p = self._cursor
        p._next._prev = p._prev
        p._prev._next = p._next
        self._cursor = p._next
        self._n -= 1

    def __str__(self):
        if not self.buida():
            p = self._sentinella._next
            s = str(p._element)
            p = p._next
            while p != self._sentinella:
                s += ' -- ' + str(p._element)
                p = p._next
            return s
        return ''

    def __iter__(self):
        self.anar_al_principi()
        return self

    def __next__(self):
        if self.final():
            raise StopIteration
        else:
            resultat = self.element()
            self.endavant()
            return resultat

    def insereix_llista_posicio(self,lst,i):
        # PRE: i és una posició vàlida: 0 <= i < self._n
        #      self no és buida (self._n > 0)
        #      lst és una instància de la classe Llista
        # Aquest mètode insereix la llista lst *abans* de la posició i de self
        # lst queda buida i els nodes d'lst s'incorporen a self.
        # No cal crear cap instància de _Node nova. Cap ni una.
        # No es poden fer servir mètodes de la classe Llista
        # (excepte per buidar el paràmetre lst, on només cal fer servir __init__)
        # No retorna res (és a dir, retorna None). És un mètode destructiu.

        # Aquesta és la funció que cal que l'estudiant completi
        
#------------------------------------------------------------------

# Llegeixo la mida de la llista d'entrada
n = int(item())

lst = Llista()
for _ in range(n):
    lst.inserir(int(item()))

# Llegeixo la mida de la llista a inserir
m = int(item())

inser = Llista()
for _ in range(m):
    inser.inserir(int(item()))

pos = int(item())  # 0 <= pos < n

lst.insereix_llista_posicio(inser,pos)
print(lst)

