# Insereix llista

Volem afegir el mètode **`insereix_llista_posicio(lst,pos)`** a la
classe `Llista`.

Suposem que tenim una llista no buida `ll` (instància de la classe
`Llista`), una altra llista `lst` (també instància de la classe
`Llista`) i una posició `pos` *correcte* de la llista `ll` (és a dir
$0 \leq \texttt{pos} < \texttt{ll.mida()}$).

El resultat d'invocar el mètode `ll.insereix_llista_posicio(lst,pos)`
és:

- `ll` creix ja que s'insereix la llista `lst` tot just *abans* de la
  posició `pos` de la llista `ll`.

- La llista `lst` queda buida. És a dir, després de la crida al mètode,
  `lst.buida()` retorna `True`.

Per exemple, si la llista `ll` és $2\ 90\ 3\ 8\ 7\ 5\ 4\ 2\ 87\ 67$, la
llista `lst` és $-100\ 23 \ 41$ i `pos` és $3$, la invocació
`ll.insereix_llista_posicio(lst,pos)` deixarà la llista `ll` com
$2\ 90\ 3\ -100\ 23\ 41\ 8\ 7\ 5\ 4\ 2\ 87\ 67$ i la llista `lst`
quedarà buida (`lst.buida()` retorna `True`)

## Precondició

La llista sobre la que s'invoca el mètode (el *paràmetre implícit*) no
pot ser buida.

La llista paràmetre `lst` és instància de la classe `Llista`

La posició `pos` és *correcte* respecte a la llista sobre la que
s'invoca el mètode. És a dir, si fem
`ll.insereix_llista_posicio(lst,pos)`, aleshores
$0 \leq \texttt{pos} < \texttt{ll.mida()}$.

## Entrada

Primer hi ha un natural $n$, que ens indica el nombre d'elements de la
llista. Després apareixen $n$ nombres enters, que formen la llista
inicial. Es garanteix que $n > 0$.

Després trobem un natural $m$, que ens indica el nombre d'elements de la
llista a inserir. Tot seguit hi ha $m$ nombres enters, que formen la
llista que volem inserir a la llista anterior.

Finalment trobem un natural $p$, que és la posició on volem inserir la
llista. És garanteix que $0 \leq p < n$.

Vegeu els exemples que formen el joc de proves públic.

## Sortida

La representació textual de la llista inicial després de fer la
corresponent inserció de la llista indicada a l'entrada a la posició
corresponent. Recordem que la representació textual de les llistes
s'obté fent `print(`$lst$`)` (on $lst$ és una instància de la classe
`Llista`).

## Observacions

Dins el codi del mètode demanat **NO** podeu fer servir cap mètode de la
classe `Llista` (hi ha una excepció: no és imprescindible, però podeu
fer servir el mètode `__init__` per buidar la llista paràmetre). Heu de
manipular exclusivament les instàncies de `_Node` que formen la
implementació de les llistes.

Vegeu els comentaris del mètode per completar al fitxer **`code.py`**.

Heu de baixar-vos el fitxer **`code.py`** (icona de la serp). Aquest
fitxer és un programa amb **tot** el que cal per executar els jocs de
prova públics. Només falta, clar, el mètode que us demana l'enunciat.
Aquest fitxer l'heu de completar amb el codi que falta, i això, **tot**,
és el que heu d'enviar al Jutge com a solució.

L'eficiència i la qualitat de la solució es tindran en compte a la
correcció manual.

## Informació del problema

Autoria: Jordi Delgado

Generació: 2026-01-25T13:15:37.726Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
