# Prokaryote Growths (1)

A petri dish is represented as a grid of size $N\times{M}$, where:

- `B` represents a bacterium

- `.` represents an empty space

At each growth cycle, each bacterium spreads to its neighboring cells in
horitzontal and vertical directions (i.e., up, down, left, right).

Write a function `growth_cycle(grid)` that, given an $N\times{M}$ matrix
representing the initial state of the colony, returns the state of the
petri dish after one growth cycle.

**EXAMPLES**

                     **Example 1**  
  ----------------- --------------- ------------------------------------------------
  Inital state                      After 1 cycle (new cells in boldface)
  `. . . . . B .`                   `. . . `**`B`**` `**`B`**` B `**`B`**
  `. . . B . . .`                   **`B`**` . `**`B`**` B `**`B`**` `**`B`**` . `
  `B . . . . . .`                   `B `**`B`**` . `**`B`**` . `**`B`**` .`
  `. . . . . B .`                   **`B`**` . . . `**`B`**` B `**`B`**
  `. . . . . . .`                   `. . . . . `**`B`**` .`

 \

                       **Example 2**  
  ------------------- --------------- -----------------------------------------
  Inital state                        After 1 cycle (new cells in boldface)
  `. . . . . . . .`                   `. . . `**`B`**` . . . .`
  `. . . B . . . .`                   `. . `**`B`**` B `**`B`**` . . .`
  `. . . B . . . .`                   **`B`**` . `**`B`**` B `**`B`**` . . .`
  `B . . . . . . .`                   `B `**`B`**` . `**`B`**` . . . .`

 \

                   **Example 3**  
  --------------- --------------- ---------------------------------------
  Inital state                    After 1 cycle (new cells in boldface)
  `. . . . . .`                   `. `**`B`**` . `**`B`**` . .`
  `. B . B . .`                   **`B`**` B `**`B`**` B `**`B`**` .`
  `B . . . . .`                   `B `**`B`**` . `**`B`**` . `**`B`**
  `. . . . . B`                   **`B`**` . . . `**`B`**` B`
  `. . . . . B`                   `. . . . `**`B`**` B`
  `. . . . . .`                   `. . . . . `**`B`**

## Observation

- In order to avoid spreading newly born cells, use a new matrix to
  store the new status of the dish.

- It may be useful to write a function `inside(grid,p,q)` that returns
  `True` if position (`p`,`q`) is inside the limits of `grid`, and
  `False` otherwise.

**Important**: Submit only the function. If you have a main program,
comment it out or embed it inside a conditional clause
`if __name__ == "__main__":`

## Problem information

Author: Lluís Padró

Generation: 2026-01-25T13:14:52.714Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
