# Clojure --- El Subfactorial amb Trampolí

Es defineix la funció **`!n`** (CAP, tema 1, plana 25), de la següent
manera (`!n` s'anomena *subfactorial*):

$$\begin{equation}
\begin{split}
!0 & = 1 \\
!1 & = 0 \\
!2 & = 1 \\
!n & = (n-1) \times (!(n-1) + !(n-2)) \text{ si $n > 2$} 
\end{split}
\end{equation}$$

Podem implementar-la, de manera molt ineficient, fent servir la
definició matemàtica:

    (defn subfact_recursiva [n]
       (cond
          (or (= n 0) (= n 2))   1
          (= n 1)                0
          :else (*' (dec n)
                    (+' (subfact_recursiva (dec n))
                        (subfact_recursiva (- n 2))))))

Passeu aquesta funció a *continuation passing style* per obtenir-ne la
versió recursiva final. Anomeneu-la **`subfact-cps`**.

Després, *trampolinitzeu* `subfact-cps` per no obtenir l'error de *Stack
Overflow*. Anomeneu-la **`subfact-t`**.

## Observacions

Cal que envieu un fitxer amb la definició de les **dues** funcions
`subfact-cps` i `subfact-t`.

## Informació del problema

Autoria: Jordi Delgado

Generació: 2026-01-25T13:14:01.054Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
