# Decodificación

La **decodificación** de un natural $n$ es una cadena de caracteres de
modo que cada dos dígitos de $n$ representan un carácter. Por ejemplo,
la decodificación de $n = 6568$ es `AD`, porque el código ASCII del
carácter `A` es 65 y el carácter ASCII del carácter `D` es 68. Tenga en
cuenta que $n$ tiene dos grupos de dos dígitos: $65$ y $68$. Otro
ejemplo: la decodificación de $65666768$ es `ABCD`, ya que $n$ se
compone de $65$, $66$, $67$ y $68$.

Es necesario implementar la función **recursiva**
`void decodificacio(int)` con la siguiente especificación:

`PRE: ` La entrada es un entero $n$ como:

1.  $n \geq 65$

2.  $n = d_1 d_2 d_3 d_4 \dots d_{m-1} d_m$.

3.  $m$ es par

4.  por cualquier par de dígitos $d_i d_{i+1}$ ($i$ impar) tenemos que
    $65 \leq d_i d_{i+1} \leq 90$.

`POST:` escribe por el canal de salida `cout` la decodificación de $n$.

## Observación

Solo se aceptan soluciones recursivas.

**IMPORTANTE:** Sólo hay que enviar la función que se pide, y quizás
otras acciones y funciones necesarias. Hay que mantener, sin embargo,
las definiciones de tipos y los `#include`s.

## Entrada

La entrada consiste en un natural $n \geq 65$ como
$n = d_1d_2d_3d_4 \dots d_{m-1}d_m$ $m$ es par y por cualquier par de
dígitos $d_i d_{i+1}$ como $i$ es impar, tenemos que
$65 \leq d_i d_{i+1} \leq 90$.

## Salida

Por cada entero $n$, su decodificación.

## Información del problema

Autoría: PRO1

Generación: 2026-01-25T13:12:05.168Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
