# Comprovació de daus trucats

Els daus, pel joc, s'han utilitzat des de l'antiguitat i actualment
encara s'utilitzen. També fa molt de temps que existeix l'astúcia dels
tramposos que trucaven aquests daus.

Un dau trucat està esbiaixat a favor d'algun resultat, de manera que
aquest resultat surt més sovint que no pas els altres. També podem dir
que està esbiaixat contra un resultat, de manera que aquest surt menys
sovint que els altres.

Una forma per detectar si un dau està trucat és mitjançant
l'estadística: si un dau és just, les cares haurien d'aparèixer amb una
freqüència similar quan es fan moltes tirades.

Un test senzill per detectar si un dau pot estar trucat és comparar les
freqüències relatives de cada cara amb la que s'esperaria si el dau fos
just. En un dau just de $n$ cares, totes les cares tenen la mateixa
probabilitat: $1/n$, o el que és el mateix, un percentatge esperat de
$100/n \%$.

La idea seria calcular el percentatge d'aparicions de cada cara i
comprovar si alguna s'allunya massa del valor esperat ($100/n$). Si hi
ha una desviació superior a un cert llindar (per exemple, $5\%$), es
podria sospitar que el dau està trucat.

Implementa una **funció ITERATIVA** que donat un enter positiu $n$ que
indica el nombre de cares del dau, una llista d'enters de valors entre 1
i $n$ i un real que correspon al llindar indica si segons aquestes
tirades i el llindar, aquest dau està trucat. A més torna una llista amb
el freqüència relativa de cada cara del dau.

## Interfície

La capçalera de la funció és la següent:

    // Pre: n > 0, llindar >= 0, tirades conté valors que pertanyen al 
    //   rang [1..n], freqs és buit
    // Post: retorna cert si la llista "tirades" indica que el dau està 
    //   trucat; false en cas contrari. A més torna a "freqs" "n" reals 
    //   que són les freqüències relatives de cada cara del dau segons 
    //   la llista "tirades".
    bool esta_trucat(int n, double llindar, const list<int> &tirades, 
                     list<double> &freqs)

## Exemple

Per exemple,

$$esta\_trucat(4, 10, [1, 4, 4, 2, 3, 2, 4, 3])$$

que correspon a diverses tirades amb un dau de 4 cares generaria la
següent llista de freqüències relatives per cada cara

$$[12.5, 25, 25, 37.5]$$

Amb aquesta nova llista i aplicant el test per detectar daus trucats amb
un llindar del 10% tornaria cert (el dau està trucat).

    	Cara 1: |25 - 12.5| > 10
    	Cara 2: |25 - 25|
    	Cara 3: |25 - 25| 
    	Cara 4: |25 - 37.5| > 10

És a dir, les cares 1 i 4 superen el llindar indicat.

## Observació

Les funcions i accions que creïs han de treballar només amb llistes (la
classe `list` de la biblioteca STL) o arrays dinàmics. Has de trobar una
solució **ITERATIVA** i eficient del problema. Si crees funcions/accions
auxiliars, afegeix-hi les corresponents **Precondició** (Pre) i
**Postcondició** (Post). En els bucles inclou l'**invariant del bucle**
i la **funció de fita**.

**IMPORTANT**: Només cal enviar el procediment demanat; el programa
principal serà ignorat.

Per tal que els jocs de proves siguin més llegibles el quart paràmetre
de la funció (en el que es retorna les freqüències relatives de cada
cara del dau) no es mostrarà en els jocs de proves. Si s'hagués de
mostrar seria en tots els casos una llista buida (com s'indica a la
Precondició).

## Informació del problema

Autoria: Bernardino Casas

Generació: 2026-01-25T13:10:31.234Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
