#include <iostream>
#include <string>
#include <list>
#include <sstream>

using namespace std;

bool esta_trucat(int n, double llindar, const list<int> &l, list<double> &res);

#ifndef IOLISTFUNCTIONS
#define IOLISTFUNCTIONS

template <typename T>
void readList(const string &line, list<T> &l) {
	istringstream mycin(line);
	T x;
	while (mycin >> x) {
		l.push_back(x);
	}
}

template<typename T1, typename T2>
ostream& operator<<(ostream &os, const pair<T1,T2> &x) {
	os << '<' << x.first << ',' << x.second << '>';
	return os;
}	

template <typename T>
void writeListRec(typename list<T>::const_iterator it, typename list<T>::const_iterator end) {
	if (it != end) {
		cout << ", " << (*it);
		writeListRec<T>(++it, end);
	}
}

template <typename T>
void writeList(const list<T> &l) {
	if (l.empty()) {
		cout << "[]" << endl;
	}
	else {
		cout << '[' << (*l.begin());
		writeListRec<T>(++l.begin(), l.end());
		cout << ']';
	}
}

#endif

int main() {
	int n;
	double llindar;
	while (cin >> n >> llindar) {
		string lin;
		getline(cin, lin);
		int i1 = lin.find('[');
		int i2 = lin.find(']', i1+1);
		string s = lin.substr(i1+1, i2-i1-1);

		list<int> la;
		readList(s, la);
		
		list<double> res;
		bool trucat = esta_trucat(n, llindar, la, res);
		
		cout << boolalpha << trucat << " / ";
		writeList(res);
		cout << endl;
	}	
	return 0;
}
