# Els Permisos de Residència

La Conselleria d'Interior ha decidit desenvolupar un sistema nou més
just per atorgar permisos de residència, alhora que també dona als
candidats menys benestants la possibilitat de guanyar. La idea és que
els candidats a un permís comprin bitllets de loteria que estan numerats
de l'$1$ fins a un número màxim $N$. El sistema de loteria consisteix
aleshores en una sèrie de rondes on certs números són eliminats o
descartats fins que només en queden alguns.

La idea bàsica del sistema d'eliminació en la loteria és semblant a
l'antic sistema de la legió imperial romana de delmació. Aquí el sistema
no és tan brutal. El sistema de loteria consisteix simplement a eliminar
cada $K$-è bitllet i després repetir el procés fins que només quedin $W$
bitllets. Aquests són els bitllets guanyadors.

Feu una funció **`trobar_guanyadors_amb_cua(N, K, W)`** que, *fent
servir una cua per resoldre el problema*, retorni una llista ordenada
amb els $W$ guanyadors.

## Precondició

$N$: Nombre total de bitllets ($1$ a $N$). $N > 1$

$K$: Factor d'eliminació (eliminar cada $K$-è element). $K < N$

$W$: Nombre de bitllets guanyadors que han de quedar. $W < N$

## Entrada

Un grup de tres nombres enters $N$, $K$ i $W$

Vegeu els exemples que formen el joc de proves públic.

## Sortida

Una llista ordenada amb els $W$ nombres guanyadors (donats els $N$, $K$
i $W$ llegits).

Vegeu els exemples que formen el joc de proves públic.

## Observacions

Heu de baixar-vos el fitxer **`code.py`** (icona de la serp). Aquest
fitxer és un programa amb **tot** el que cal per executar els jocs de
prova públics. Només falta, clar, la funció que us demana l'enunciat.
Aquest fitxer l'heu de completar amb el codi que falta, i això, **tot**,
és el que heu d'enviar al Jutge com a solució.

Hi ha altres maneres de resoldre aquest problema. En aquest enunciat es
demana *explícitament* que ho feu *utilitzant una cua*. La classe `Cua`
ja està definida al fitxer **`code.py`**.

L'eficiència i la qualitat de la solució es tindran en compte a la
correcció manual.

## Informació del problema

Autoria: Jordi Delgado

Generació: 2026-01-25T13:09:48.269Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
