# Aproximació del cosinus usant Taylor

Es vol aproximar el valor del **cosinus** d'un angle donat, emprant el
desenvolupament en sèrie de Taylor de la funció $\cos(\theta)$ centrat a
0 (sèrie de Maclaurin).

Escriu un programa que donat un flux de parells de nombres naturals
$(g, n)$, per a cada parell calculi i escrigui una aproximació de
$\cos(\theta)$, on $\theta$ és l'angle $g$ expressat en graus.
L'aproximació s'ha d'obtenir sumant els $n$ primers termes de la sèrie
següent:

$$\cos(\theta) \approx \sum_{k=0}^{n-1} (-1)^k \frac{\theta^{2k}}{(2k)!} = \frac{\theta^0}{0!} - \frac{\theta^2}{2!} + \frac{\theta^4}{4!} - \frac{\theta^6}{6!} + \ldots$$

**Important:** abans de calcular la sèrie, cal convertir l'angle a
radians mitjançant la fórmula:
$$\theta_{\text{radians}} = g \cdot \frac{\pi}{180}$$ Defineix $\pi$ com
una constant amb valor `3.141593`.

## Entrada

El programa rep un flux de dades format per diversos parells de valors:

- Un nombre natural $g$, que representa l'angle en graus.

- Un nombre natural $n$, que indica el nombre de termes de la sèrie de
  Taylor que s'han de sumar.

## Sortida

Per a cada parell d'entrada, el programa ha d'escriure en una línia el
valor aproximat de $\cos(g^\circ)$ amb 6 decimals de precisió.

Per mostrar nombres reals amb 6 decimals de precisió, cal incloure la
biblioteca `<iomanip>` i utilitzar la següent instrucció:

    	cout << fixed << setprecision(6) << num << endl;

El format de sortida ha de coincidir exactament amb el dels jocs de
prova.

## Observació

Per resoldre aquest exercici no es poden utilitzar variables de tipus
`string`, taula ni `vector`.

## Informació del problema

Autoria: Bernardino Casas

Generació: 2026-01-25T13:07:32.431Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
