#include <cassert>
#include <iostream>
#include <vector>
#include <iomanip>

using namespace std;

typedef vector <int>   Vector;
typedef vector<Vector> Matriu;

/*
 * PRE:  M.size() > 0 and M[0].size() > 0, és una matriu d'enters.
 *		 quitra > 0, limit > 0.
 *		 recorregut.size() > 0 i recorregut només conté 'N','S','E','O'.
 *
 * POST: Retorna PAVIMENTAT hem pogut pavimentar tot el recorregut.
 * 		 Retorna NO_PROU_QUITRA si no tenim prou quitrà per a pavimentar
 *               el recorregut. 
 * 		 M estarà modificada amb tot el recorregut que s'hagi pogut pavimentar.
 */

string matriu_paviment(Matriu& M,int q, int l, const string& recorregut);

void escriu_matriu(const Matriu& M)
{
    const char separador = ' ';
    const int amplada	 = 4;

	assert(M.size() > 0);
	int f = M.size();
	int c = M[0].size();
	
	for (int i = 0 ; i < f ; i++)
	{
		for (int j = 0 ; j < c ; j++)
			cout << setw(amplada) << M[i][j] << setfill(separador);
		cout << endl;
	}
	return;
}

void llegeix_matriu(Matriu& M, int f, int c)
{
	assert(M.size() > 0);
	assert(M.size() == f and M[0].size() == c);
	
	for (int i = 0 ; i < f ; i++)
		for (int j = 0 ; j < c ; j++)
			cin >> M[i][j];

	return;
}

int main() 
{
	int f,c;
	cin >> f >> c;
	
	Matriu M(f,Vector(c,0));

	llegeix_matriu(M,f,c);
//	escriu_matriu(M);

	int quitra,limit;
	string recorregut;
	while (cin >> quitra >> limit >> recorregut)
	{
		string s = matriu_paviment(M,quitra,limit,recorregut);
		escriu_matriu(M);
		cout << "QUITRA: " << quitra << " LIMIT: " << limit;
		cout << " RECORREGUT: " << recorregut << " RESULTAT: " << s << endl;
	}

	return 0;
}
