# Lliga de Bàsquet

Després de molts entrebancs, la Federació Catalana de Bàsquet ha reeixit
a organitzar la Lliga Nacional Catalana de Bàsquet i ha demanat a la FIB
que els ajudi amb la gestió de les dades dels resultats de la temporada.

Concretament, heu de fer un **programa** tal que donat un enter
$n \geq 2$ i $n$ noms **diferents** d'equips de bàsquet catalans i
després un nombre indeterminat de resultats en forma de quàdruples:

$$equip_1 ~~ cistelles_1 ~~ equip_2 ~~ cistelles_2$$

que representen el resultat d'un partit, calculi la classificació final
tenint en compte que l'ordre ve donat per:

1.  El nombre de punts (partit guanyat: 1 punt). Tingueu en compte que
    en bàsquet no hi ha empats.

2.  En cas d'empat a punts, va primer qui té millor bàsquet average
    (diferència entre punts fets i punts rebuts).

3.  En cas d'empat en tots dos casos anteriors, qui té el nom d'equip
    **mes gran** en ordre lexicogràfic.

Per a fer aquest programa **cal** fer servir aquesta estructura:

    struct Equip
    {
        string nom;
        int punts_favor;
        int punts_contra;
        int guanyats;
    };

## Observació

El nombre $n \geq 2$ d'equips no ha de ser necessàriamen parell. De la
mateixa manera, els partits que hi haurà no han de ser necessàriament
tots els possibles (és a dir, tots contra tots a casa i a fora).

Tot i que és irrellevant per al vostre programa, un partit no podrà
aparèixer més d'una vegada, ni tan sols amb resultats diferents.

En un partit només hi apareixeran equips que hagin aparegut a la llista
inicial d'$n$ equips.

No es pot fer servir l'operació `sort` de la biblioteca `stl`. Si heu
d'ordenar algun vector, ho heu de programar vosaltres. I si fos el cas,
qualsevol mètode d'ordenació dels que heu estudiat és vàlid.

Fixeu-vos en el segon exemple: tots els equips han guanyat el mateix
nombre de partits i tots tenen el mateix bàsquet average. Els equips van
ordenats en aquest cas en ordre lexicogràfic invers.

## Entrada

Un enter $n > 1$ i $n$ noms d'equip de bàsquet seguits d'un nombre
indeterminat de resultats en forma de quàdruples:

$$equip_1 ~~ cistelles_1 ~~ equip_2 ~~ cistelles_2$$

que representen el resultat d'un partit.

## Sortida

La classificació final en el format indicat als exemples, i amb els
criteris d'ordenació esmentats a l'enunciat.

## Informació del problema

Autoria: PRO1

Generació: 2026-01-25T13:06:13.419Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
