#include <iostream>
#include <string>
#include <queue>
#include <sstream>

using namespace std;

queue<int> intercala_cues(const queue<int> &cua1, const queue<int> &cua2);

#ifndef IOSTACKFUNCTIONS
#define IOSTACKFUNCTIONS

queue<int> readQueue(const string &line) {
	istringstream mycin(line);
	queue<int> q;
	int x;
	while (mycin >> x) {
		q.push(x);
	}
	return q;
}

void readQueues(const string &line, queue<int> &q1, queue<int> &q2) {
	int i1 = line.find('[');	
	int i2 = line.find(']', i1+1);	
	int i3 = line.find('[', i2+1);
	int i4 = line.find(']', i3+1);
	q1 = readQueue(line.substr(i1+1, i2-i1-1));
	q2 = readQueue(line.substr(i3+1, i4-i3-1));
}

void writeQueueRec(queue<int> &q) {
	if (not q.empty()) {
		cout << q.front();
		q.pop();
		if (not q.empty()) cout << ' ';
		writeQueueRec(q);
	}
}

void writeQueue(queue<int> q) {
	cout << '[';
	writeQueueRec(q);
	cout << ']';
	cout << endl;
}

#endif

int main() {
	string l;
	while (getline(cin, l)) {
		queue<int> q1, q2;
		readQueues(l, q1, q2);
		writeQueue(intercala_cues(q1, q2));
	}	
	return 0;
}
