# Cambios de ranking

En una competición deportiva, se mantienen clasificaciones de los
jugadores. Cada jugador tiene un nombre único (un `string` sin espacios)
y un ranking (su posición en la clasificación). Queremos detectar los
cambios de ranking entre dos clasificaciones consecutivas.

Por ejemplo, si la primera clasificación es:

    bobby
    millie
    poikee
    sully
    jamie

Y la segunda clasificación es:

    jamie
    millie
    bobby
    sully
    poikee

Los cambios de ranking son:

- `bobby` pasa de la posición 1 a la 3 (baja 2 posiciones: $-2$)

- `jamie` pasa de la posición 5 a la 1 (sube 4 posiciones: $+4$)

- `poikee` pasa de la posición 3 a la 5 (baja 2 posiciones: $-2$)

Observad que `millie` y `sully` no cambian de posición.

Haz un **programa** que lee dos clasificaciones y muestra los cambios de
ranking. Las dos clasificaciones de la entrada están **ordenadas por el
ranking**, del primero al último (la posición 1 es la primera línea, la
posición 2 es la segunda, etc.). La salida debe estar **ordenada por el
nombre** de los jugadores, y solo hay que mostrar los jugadores que han
cambiado de posición.

## Observación

Este problema tiene como centro de interés la *eficiencia*. Usad los
mejores algoritmos y estructuras de datos que podáis y considerad que
recibiréis datos de entrada de grandes dimensiones.

En este problema es **muy importante** utilizar la función `sort` de la
librería estándar de C++ (`#include <algorithm>`), ya que si no se
utiliza, el programa dará *EE, time-limit exceeded*.

La mitad de los puntos otorgados por la corrección automática
corresponden a la corrección del programa, y la otra mitad a la
eficiencia.

## Entrada

La entrada empieza con un entero $n$ ($n \geq 1$) que indica el número
de jugadores. Después vienen $n$ líneas con los nombres de los jugadores
de la primera clasificación, ordenados por el ranking (del primero al
último). A continuación, vienen otras $n$ líneas con los nombres de los
jugadores de la segunda clasificación, también ordenados por el ranking.

## Salida

La salida son los jugadores que han cambiado de posición, **ordenados
alfabéticamente por el nombre**. Para cada jugador que ha cambiado, se
escribe una línea con el nombre y la diferencia de ranking. Si un
jugador ha subido posiciones (es decir, su ranking ha mejorado, ha
pasado a un número más pequeño), la diferencia es positiva y se muestra
con un `+` delante. Si ha bajado posiciones, la diferencia es negativa.

Si ningún jugador ha cambiado de posición, se escribe `No hi ha canvis.`

## Información del problema

Autoría: Unknown\
Traducción: Pau Fernández

Generación: 2026-02-03T07:41:26.362Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
