# Nonograma

El *Nonograma* és un puzzle de lògica en que les cel·les d'una graella
s'han d'omplir o deixar en blanc tenint compte els nombres que hi ha al
costat de la figura per tal de mostrar un dibuix amagat.

Tens un tauler de *nonograma* de $n$ files i $m$ columnes. Cada fila i
cada columna té unes *pistes* (una seqüència de nombres) que indiquen
les longituds dels blocs consecutius de cel·les plenes (`X`) que hi han
d'aparèixer, en el mateix ordre i separats, com a mínim, per una cel·la
buida (`.`).

Has de fer un programa que simuli una partida amb una interfície
textual:

- Inicialment, totes les cel·les del tauler estan buides (`.`).

- Després de llegir les pistes, s'ha de mostrar el tauler inicial.

- A continuació es llegeixen ordres (una per línia) fins que:

  - l'usuari escriu `Z` (acaba la partida), o

  - el tauler compleix totes les pistes (victòria).

Les ordres possibles són:

`A f c`

:   Marca la cel·la $(f,c)$ com a plena (`X`). Si ja era `X`, no canvia
    res.

`B f1 c1 f2 c2`

:   Marca com a `X` totes les cel·les del rectangle delimitat per
    $(f1,c1)$ (cantonada superior esquerra) i $(f2,c2)$ (cantonada
    inferior dreta).

`E f c`

:   Deixa la cel·la $(f,c)$ buida (`.`). Si ja era `.`, no canvia res.

`F f1 c1 f2 c2`

:   Deixa buides (`.`) totes les cel·les del rectangle delimitat per
    $(f1,c1)$ i $(f2,c2)$.

`R`

:   Reinicia el tauler a l'estat inicial (tot `.`) i posa el comptador
    de moviments a $0$.

`S`

:   Mostra el tauler en el format especificat a la secció de sortida.

`Z`

:   Finalitza la partida.

#### Moviments

Només compten com a moviments les ordres `A`, `B`, `E` i `F`. L'ordre
`R` reinicia el comptador a $0$. Les ordres `S` i `Z` no compten.

#### Condició de victòria

El tauler és correcte si, per a *cada fila* i *cada columna*, la
seqüència de longituds dels blocs consecutius de `X` coincideix
exactament amb la seva pista. Si una pista té $0$ blocs, vol dir que
aquella fila/columna no pot contenir cap `X`.

Quan s'assoleix la victòria després d'una ordre `A`, `B`, `E` o `F`,
s'ha de mostrar el tauler (encara que no s'hagi demanat amb `S`),
escriure el missatge de victòria i el nombre de moviments, i acabar.

## Entrada

L'entrada té el format següent:

- Primera línia: dos enters $n$ i $m$ ($1 \le n,m$).

- Tot seguit, $n$ línies amb les pistes de les files. Cada línia comença
  amb un enter $k$ (nombre de blocs) i continua amb $k$ enters ($k$ pot
  ser $0$).

- Tot seguit, $m$ línies amb les pistes de les columnes. Cada línia
  comença amb un enter $k$ i continua amb $k$ enters ($k$ pot ser $0$).

- Finalment, una seqüència d'ordres, una per línia, fins que apareix `Z`
  o fins a la victòria.

**Nota:** Pots suposar que totes les ordres són correctes i que els
índexs de files i columnes que apareixen a les ordres són vàlids (les
files i columnes es numeren des de $1$).

## Sortida

Primer s'ha d'escriure el tauler inicial i, després, cada vegada que es
rebi una ordre `S`, s'ha de tornar a escriure el tauler.

El tauler s'imprimeix així:

- Capçalera amb els números de columna ($1$ a $m$) en camps d'amplada
  $3$ (alineats a la dreta) precedits per $4$ espais.

- Una línia separadora amb $4$ espais i després $3m-1$ guionets (`-`).

- Per a cada fila $i$:

  - el número de fila en un camp d'amplada $2$ (alineat a la dreta),

  - espai, ,

  - les $m$ cel·les separades per *dos* espais (cada cel·la és `.` o
    `X`),

  - espai, ,

  - espai i la pista de la fila (els nombres separats per un espai). Si
    la pista té $0$ blocs, no s'escriu cap nombre.

- Una altra línia separadora igual.

- A sota, les pistes de les columnes impreses en $H$ línies, on $H$ és
  el màxim nombre de blocs entre totes les columnes. Les pistes
  s'imprimeixen **alineades a dalt**: a la línia $r$ ($1 \le r \le H$),
  per a cada columna s'escriu el seu $r$-è bloc si existeix, en un camp
  d'amplada $3$; en cas contrari, s'escriuen $3$ espais. Cada línia
  comença amb $4$ espais.

Quan el joc acaba:

- Si acaba per victòria, després d'imprimir el tauler final s'escriu:

      Enhorabona! Has resolt el nonograma.
      Nombre de moviments: X
      	

- Si acaba per l'ordre `Z`, s'escriu:

      Has sortit del joc. Fins aviat!
      Nombre de moviments: X
      	

on `X` és el nombre total de moviments comptats segons les regles
anteriors.

## Informació del problema

Autoria: Bernardino Casas

Generació: 2026-01-25T13:03:30.768Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
