#include <iostream>
#include <sstream>

Llista::Llista() : _prim(nullptr), _long(0) {}
   
Llista::~Llista() {
  node *p, *pelim;
  if (_prim != nullptr) {
    p = _prim->seg;
    while (p != _prim) {
      pelim = p;
      p = p->seg;
      delete pelim;
    }
    delete _prim;
  }
}

nat Llista::longitud() const {
  return _long;
}

void Llista::mostra() const {
  node *p = _prim;
  cout << "[";
  if (p != nullptr) {
    cout << p->info;
    p = p->seg;
    while (p != _prim) {
      cout << " " << p->info;
      p = p->seg;
    }
  }
  cout << "]" << endl;
}

int main() {
  int n;
  cin >> n; // Nombre elements de la llista
  Llista l(n);
  cout << l.longitud() << " ";
  l.mostra();

  cin >> n; // Comptador per anar matant cada k elements
  l.josephus(n);
  cout << l.longitud() << " ";
  l.mostra();
  return 0;
}
