# Mètode de la classe BinaryTree amb un ABC que genera el camí entre l'arrel i l'element indicat

Implementa un nou mètode RECURSIU de la classe `BinaryTree` que genera
una llista amb el camí entre l'arrel i l'element indicat. Aquest arbre
binari emmagatzema un **Arbre Binari de Cerca** (ABC, o BST en anglès).

Entre els fitxers que s'adjunten en aquest exercici, trobaràs
`BinaryTree.old.hpp`, a on hi ha una implementació de la classe genèrica
`BinaryTree`. En primer lloc, hauràs de fer:

    cp BinaryTree.old.hpp BinaryTree.hpp

A continuació si obres el fitxer `BinaryTree.hpp` al final del mateix
trobaràs el mètode que has d'implementar:

    // Pre: p.i. emmagatzema un arbre binari de cerca sense elements repetits,
    //    res és una llista buida
    // Post: Torna a res el camí entre l'arrel i x. Si x no es troba en el p.i.
    //    llavors res serà buit.
    template <typename T>
    void BinaryTree<T>::route_bst(const T &x, list<T> &res) const {
    }

[**IMPORTANT**]{style="color: red"}: No toquis la resta de la
implementació de la classe, excepte si necessites afegir algun mètode
auxiliar o atribut a la part privada.

També pots trobar entre els fitxers que s'adjunten a l'exercici el
fitxer `program.cpp` (programa principal) i `Makefile` per a compilar i
generar l'executable. El programa principal que t'oferim ja s'encarrega
de llegir els arbres binaris i fer les crides al mètode indicat. **Només
cal que implementis el mètode `route_bst`**.

Per a pujar la teva solució, has de crear el fitxer `solution.tar` així:

    tar cf solution.tar BinaryTree.hpp

## [Observació]{style="color: blue"}

Recorda que si crees funcions auxiliars, has d'afegir-hi les
corresponents **Precondició** (Pre) i **Postcondició** (Post). Has de
trobar una solució **RECURSIVA** i eficient del problema. En particular,
no hi hauria d'haver cap bucle en cap de les funcions/accions que
implementis. En les crides recursives inclou la **hipòtesi d'inducció**
(HI) i la **funció de fita** (FF).

## Entrada

Una seqüència d'arbres binaris de cerca.

## Sortida

Per a cada arbre binari de cerca s'escriurà el resultat del mètode
`route_bst`.

El programa principal que t'oferim ja s'encarrega de llegir la seqüència
d'arbres binaris i fer les crides als corresponents al mètode de
`BinaryTree` que se't demana d'implementar. Només cal que facis les
modificacions abans esmentades dins el fitxer `BinaryTree.hpp`.

Per més detalls de com és l'entrada i la sortida consulta els jocs de
proves públics.

## Informació del problema

Autoria: Bernardino Casas

Generació: 2026-01-25T20:34:55.888Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
