#include <iostream>
#include <list>
#include <string>

using namespace std;

#include "BinaryTree.hpp"

template <typename T>
void writeListRec(typename list<T>::const_iterator it, typename list<T>::const_iterator end) {
  if (it != end) {
    cout << ", " << *it;
    writeListRec<T>(++it, end);
  }
}

template <typename T>
void writeList(const list<T> &l) {
  if (l.empty()) {
    cout << "[]" << endl;
  }
  else {
    cout << '[' << *l.begin();
    writeListRec<T>(++l.begin(), l.end());
    cout << ']' << endl;
  }
}

int main() {
  int x;
  while (cin >> x) {
    // Inv: s'ha llegit el arbres s1 i s'ha comprovat si són equidistants.
    string s1;
    cin >> s1;
    
    BinaryTree<int> t1;
    readStringTree(s1, t1);
    
    cout << x << ' ';
    writeStringTree(cout, t1);
	cout << " --> ";

    list<int> cami;
    t1.route_bst(x, cami);
    writeList(cami);
  }
}
