# Cifrado por Sustitución

Escribir una función **`decodifica(t)`** tal que dada una *string*
**`t`** de $26$ carácteres que representa una tabla de codificación,
retorne una función que, dada una *string* **`s`**, la decodifique
siguiendo la *string* **`t`**.

La *string* **`t`** representa una tabla que indica cómo codificar el
alfabeto siguiendo un *cifrado por sustitución*. Esta tabla **`t`** debe
tener exactamente $26$ carácteres y no ha de haber ninguno repetido.

Supondremos que los textos que se quiere decodificar se escribieron,
antes de ser codificados, utilizando tan solo los carácteres
`’abcdefghijklmnopqrstuvwxyz’` y el espacio. El espacio siempre se
codificará con `’_’`. Así, la tabla **`t`** codificará textos haciendo
que la letra `’a’` sea **`t[0]`**, la letra `’b’` sea
**`t[1]`**,$\dots$, la letra `’z’` sea **`t[25]`**.

Por ejemplo, haciendo:

**`f = decodifica(’aikvfdrzblnsqtowuepgmjcyhx’)`**

entonces el resultado de **`f(’fpgf_fyaqft_to_fp_qmh_vbdbkbs’)`**
debería ser **`’este examen no es muy dificil’`**

Hay más ejemplos en el juego de pruebas público.

## Entrada

La función tiene una *string* de tamaño $26$ como parámetro.

## Observaciones

Si se tiene una lista de carácteres **`lst`** y se quiere convertir a
*string* se puede hacer con **`’’.join(lst)`**. Por ejemplo, el
resultado de hacer
**`’’.join([’h’,’o’,’l’,’a’,’ ’,’m’,’u’,’n’,’d’,’o’])`** es
**`’hola mundo’`**

No puede usarse ningún módulo adicional.

Una vez definida la función, al probarla en el REPL de Python debería
salir lo mismo que puede observar más abajo.

## Información del problema

Autoría: Jordi Delgado (basado en el problema P35941, de Salvador Roura)

Generación: 2026-01-25T13:02:16.106Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
