# Xifrat de Substitució

Escriure una funció **`descodifica(t)`** tal que donada una *string*
**`t`** de $26$ caràcters que representa una taula de codificació,
retorni una funció que, donada una *string* **`s`**, la descodifiqui
seguint la *string* **`t`**.

La *string* **`t`** representa una taula que indica com codificar
l'alfabet seguint un *xifrat de substitució*. Aquesta taula **`t`** ha
de tenir exactament $26$ caràcters i no n'ha d'haver cap de repetit.

Suposarem que els textos que volem descodificar es van escriure, abans
de ser codificats, fent servir només els caràcters
`’abcdefghijklmnopqrstuvwxyz’` i l'espai. L'espai sempre el codificarem
amb `’_’`. Així, la taula **`t`** codificarà textos fent que la lletra
`’a’` sigui **`t[0]`**, la lletra `’b’` sigui **`t[1]`**,$\dots$, la
lletra `’z’` sigui **`t[25]`**.

Per exemple, si fem:

**`f = descodifica(’aikvfdrzblnsqtowuepgmjcyhx’)`**

aleshores el resultat de **`f(’aumfpg_fyaqft_to_fp_rabef_vbdbkbs’)`** ha
de ser **`’aquest examen no es gaire dificil’`**

Veieu més exemples en els jocs de proves públics.

## Entrada

La funció té una *string* de mida $26$ com a paràmetre.

## Observacions

Si teniu una llista de caràcters **`lst`** i la voleu convertir a
*string* ho podeu fer amb **`’’.join(lst)`**. Per exemple, el resultat
de fer **`’’.join([’h’,’o’,’l’,’a’,’ ’,’m’,’ó’,’n’])`** és
**`’hola món’`**

No podeu fer servir cap mòdul addicional.

Un cop definida la funció, en provar-la al REPL de Python us hauria de
sortir el mateix que podeu observar més avall.

## Informació del problema

Autoria: Jordi Delgado (basat en el problema P35941, de Salvador Roura)

Generació: 2026-01-25T13:02:20.527Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
