# Vector Montaña

Un **vector Montaña** es un vector de enteros que tiene tres partes: una
subida, una meseta y una bajada. La subida $p_1 \dots p_k$ es un
subvector tal que todos los elementos están en orden *estrictamente
creciente*. La meseta $v_1 \dots v_m$ es un subvector en el que todos
los elementos son *iguales*. La bajada $b_1 \dots b_n$ es un subvector
tal que todos sus valores están en orden *estrictamente decreciente*.

Además, se cumplen estas dos condiciones:

1.  $k \geq 1$, $m \geq 3$ y $n \geq 1$. Dicho de otro modo: tanto la
    subida como la bajada tienen al menos un elemento, mientras que la
    meseta tiene, al menos, tres.

2.  $p_k < v_1$ y $v_m > b_1$.

Por ejemplo, el vector `V = [1 2 3 4 5 5 5 5 4 3 2]` es un **vector
Montaña**:

::: center
  ------------------------------- ------------------------------- -----------------------------
   $\underbrace{\verb|1 2 3 4|}$   $\underbrace{\verb|5 5 5 5|}$   $\underbrace{\verb|4 3 2|}$
              subida                          meseta                         bajada
  ------------------------------- ------------------------------- -----------------------------
:::

El **codo Montaña** es la posición de un vector Montaña donde se
encuentra $v_1$, es decir, el primer elemento de la meseta. Por ejemplo,
para el vector `V = [1 2 3 4 5 5 5 5 4 3 2]` la posición del codo
Montaña es 4, ya que es la posición donde se encuentra el primer
elemento de la meseta.

Debes hacer la **función** `colzeMuntanya`, que devuelve la posición del
codo Montaña de un vector Montaña.

    /* PRE:  v es un vector Montaña.
       POST: devuelve la posición del codo Montaña de v.
    */

    int colzeMuntanya(const vector<int>& v);

## Observación

Solo debes enviar un fichero que contenga la función requerida, con los
`include` necesarios y las funciones auxiliares que hayas declarado (si
las hay), y **nada más**.

Propón una solución utilizando **búsqueda dicotómica** para este
ejercicio. Cualquier otro tipo de solución implica la anulación
**total** de todo el ejercicio, independientemente del veredicto del
juez.

## Entrada

Un vector Montaña de enteros.

## Salida

La posición del codo Montaña.

## Información del problema

Autoría: PRO1

Generación: 2026-01-25T13:02:00.603Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
