# Vector Muntanya

Un **vector Muntanya** és un vector d'enters que té tres parts: una
pujada, un pla i una baixada. La pujada $p_1 \dots p_k$ és un subvector
tal que tots els elements estan en ordre *estrictament creixent*. El pla
$v_1 \dots v_m$ és un subvector on tots els elements són *iguals*. La
baixada $b_1 \dots b_n$ és un subvector tal que tots els seus valors
estan en ordre *estrictament decreixent*.

A més, es compleixen aquestes dues condicions:

1.  $k \geq 1$, $m \geq 3$ i $n \geq 1$. Dit altrament: tant la pujada
    com la baixada tenen almenys un element, mentre que el pla en té,
    almenys, tres.

2.  $p_k < v_1$ i $v_m > b_1$.

Per exemple, el vector `V = [1 2 3 4 5 5 5 5 4 3 2]` és un **vector
Muntanya**:

::: center
  ------------------------------- ------------------------------- -----------------------------
   $\underbrace{\verb|1 2 3 4|}$   $\underbrace{\verb|5 5 5 5|}$   $\underbrace{\verb|4 3 2|}$
              pujada                            pla                          baixada
  ------------------------------- ------------------------------- -----------------------------
:::

El **colze Muntanya** és la posició d'un vector Muntanya on es troba
$v_1$, és a dir, el primer element del pla. Per exemple, per al vector
`V = [1 2 3 4 5 5 5 5 4 3 2]` la posició del colze Muntanya és 4, ja que
és la posició on es troba el primer element del pla.

Has de fer la **funció** `colzeMuntanya`, que torna la posició del colze
Muntanya d'un vector Muntanya.

    /* PRE:  v és un vector Muntanya.
       POST: torna la posició del colze Muntanya de v.
    */

    int colzeMuntanya(const vector<int>& v);

## Observació

Només has d'enviar un fitxer que contingui la funció requerida, amb els
`include` necessaris i les funcions auxiliars que hauràs declarat (si
n'hi ha), i **res més**.

Proposeu una solució utilitzant **cerca dicotòmica** per aquest
exercici. Qualsevol altre tipus de solució implica l'anul·lació
**total** de tot l'exercici, independentment del veredicte del jutge.

## Entrada

Un vector Muntanya d'enters.

## Sortida

La posició del colze Muntanya.

## Informació del problema

Autoria: PRO1

Generació: 2026-01-25T13:01:56.103Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
