from pytokr import item, items

#------------------------------------------------------------------

class Pila:

    # ----------------------------------------------------
    # Classe interna per definir els elements de la pila:
    # Cada element de la pila serà una instància de _Node
    class _Node:
        __slots__ = '_element', '_next' 
        
        def __init__(self, element, next):
            self._element = element 
            self._next = next              
    # ------------------------------------------

    def __init__(self):
        self._cap = None
        self._mida = 0

    def buida(self):
        return self._mida == 0
 
    def mida(self):
        return self._mida

    def push(self, e):
        self._cap = self._Node(e, self._cap)
        self._mida += 1
        return self
        
    def cim(self):
        # Pre: La pila no és buida
        return (self._cap)._element

    def pop(self):
        # Pre: La pila no és buida
        resposta = (self._cap)._element
        self._cap = (self._cap)._next 
        self._mida -= 1
        return resposta
    
#------------------------------------------------------------------

def troba_celebritat(mat):
    # PRE: mat -- matriu n x n booleana de coneixences
    #      mat[i][j] = True si i només si i coneix j
    # RETORNA: l'identificador de la celebritat 0 <= c < n, o -1 si no hi ha celebritat
    
    # Aquí heu d'escriure el codi de la vostra solució al problema 

#------------------------------------------------------------------

# Llegeixo el nombre de convidats a la festa
n = int(item())

# Llegeixo la matriu de coneixences
M = [[] for _ in range(n)]
for i in range(n):
    for _ in range(n):
        M[i].append( (int(item()) == 1) )

# Escric el resultat
celeb = troba_celebritat(M)
print("no hi ha celebritat" if celeb == -1 else celeb)
