# Aminoacid Triplets

Write a program that processes a sequence of cases. Each case consists
of three names of aminoacid types A, B, C, followed by a protein (a
sequence of aminoacid codes) ended with the word `END`. For each case,
the program must list the triplets of consecutive amioacids in the
protein such as the first one belongs to type A, the second to type B,
and the third to type C. The total amount of found triplets for each
protein must also be printed.

The known aminoacid codes are: `ala` (alanine), `arg` (arginine), `asn`
(asparagine), `asp` (aspartic acid), `cys` (cysteine), `gln`
(glutamine), `glu` (glutamic acid), `gly` (glycine), `his` (histidine),
`ile` (isoleucine), `leu` (leucine), `lys` (lysine), `met` (methionine),
`phe` (phenylalanine), `pro` (proline), `ser` (serine), `thr`
(threonine), `trp` (tryptophan), `tyr` (tyrosine), `val` (valine).

The aminoacid types are:

    aliphatic: ['ala', 'gly', 'ile', 'leu', 'pro', 'val']
    aromatic: ['phe', 'trp', 'tyr']
    acidic: ['asp', 'glu']
    basic: ['arg', 'his', 'lys']
    hydroxylic: ['ser', 'thr']
    sulphur: ['cys', 'met']
    amidic: ['asn', 'gln']

## Input

The input is a sequence of cases. Each case starts with three aminoacid
types. Then, a sequence of aminoacid codes follows, ended with the word
`END`. There are no restrictions on the length of the protein.

## Output

The output is, for each case, the list of consecutive triplets matching
the three given types, plus the total number of found triplets. Print a
blank line after each case. Follow the format of the examples.

## Observation

**Note 1:** You can use any data structure you find useful to store
which aminoacids belong to which group.\
**Note 2:** Solutions storing the whole aminoacid sequence will receive
a severe score penalty.

## Problem information

Author: Lluís Padró

Generation: 2026-01-25T13:00:43.247Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
