#include <iostream>
#include <string>
#include <list>
#include <queue>
#include <sstream>

using namespace std;

void transferir_parells(list<int> &l, queue<int> &q);


#ifndef IOLISTFUNCTIONS
#define IOLISTFUNCTIONS

template <typename T>
void readList(const string &line, list<T> &l) {
	istringstream mycin(line);
	T x;
	while (mycin >> x) {
		l.push_back(x);
	}
}

template <typename T>
void writeListRec(typename list<T>::const_iterator it, typename list<T>::const_iterator end) {
	if (it != end) {
		cout << ", " << *it;
		writeListRec<T>(++it, end);
	}
}

template <typename T>
void writeList(const list<T> &l) {
	if (l.empty()) {
		cout << "[]";
	}
	else {
		cout << '[' << (*l.begin());
		writeListRec<T>(++l.begin(), l.end());
		cout << ']';
	}
}

template <typename T>
void writeQueue(const queue<T> &q) {
	queue<T> tmp(q);
	cout << '[';
	bool first = true;
	while (not tmp.empty()) {
		if (first) {
			first = false;
		}
		else {
			cout << ", ";
		}
		cout << tmp.front();
		tmp.pop();
	}
	cout << ']';
}

#endif

int main() {
	string lin;
	while (getline(cin, lin)) {
		int i1 = lin.find('[');
		int i2 = lin.find(']', i1+1);
		string s = lin.substr(i1+1, i2-i1-1);

		list<int> l;
		readList<int>(s, l);
		
		queue<int> q;
		transferir_parells(l, q);
		cout << "l: ";
		writeList<int>(l);
		cout << "  q: ";
		writeQueue<int>(q);
		cout << endl;
	}	
	return 0;
}
