#--------------------------------------------------------------------------

from pytokr import item

def llegeix_arbre_int():
    valor_arrel  = int(item())
    nombre_fills = int(item())
    if nombre_fills == 0:
        return Arbre(valor_arrel)
    else:
        fills = [llegeix_arbre_int() for _ in range(nombre_fills)]
        return Arbre(valor_arrel,fills)
    
#--------------------------------------------------------------------------

from collections import deque

# Arbres generals

class Arbre:
    
    def __init__(self,v,f=[]):                   # Constructora
        """ Retorna un arbre amb etiqueta v a arrel i f com a
            fills de l'arrel.
            Pre: f és una llista d'arbres """
        self._arrel = v
        self._fills = f

    def valor(self):                             # Consultora
        """ Retorna l'etiqueta de l'arrel de l'arbre a """
        return self._arrel

    def fills(self):                             # Consultora
        """ Retorna els fills de l'arbre a """
        return self._fills

    def es_fulla(self):                          # Consultora
        """ Retorna True si a és un node fulla """
        return len(self._fills) == 0

    def modifica_valor(self,v):                  # Modificadora
        """ Modifica el valor de l'arrel d'a a v """
        self._arrel = v

    def modifica_fills(self,f):                  # Modificadora
        """ Modifica els fills d'a a f.
            Pre: f és una llista d'arbres """
        self._fills = f

    # Utilitats

    def preordre(self):
        resultat = [self.valor()]
        if not self.es_fulla():
            for f in self.fills():
                resultat += f.preordre()
        return resultat
                
    def postordre(self):
        resultat = []
        if not self.es_fulla():
            for f in self.fills():
                resultat += f.postordre()
        return resultat + [self.valor()]
                
    def nivells(self):
        resultat = []
        q = deque()
        q.append(self)
        while len(q) > 0:
            tt = q.popleft() # tractem q com a CUA
            resultat += [tt.valor()]
            if not tt.es_fulla():
                for f in tt.fills():
                    q.append(f)
        return resultat

#--------------------------------------------------------------------------

def escorar(a):
    """
    Pre: a és una instància d'Arbre, amb nombres positius als nodes
    Aquesta funció és una operació NO destructiva (no modifica a)
    Retorna: El pes (suma del valor en els nodes), la mida (nombre de nodes) i l'arbre escorat
             (en aquest ordre)
    """
    # ... Aquí cal afegir el codi per completar la funció ...
    
#--------------------------------------------------------------------------

a = llegeix_arbre_int()
_, _, a_escorat = escorar(a)
preordre_escorat  = a_escorat.preordre()
postordre_escorat = a_escorat.postordre()
print(','.join(list(map(str,preordre_escorat))))
print(','.join(list(map(str,postordre_escorat))))
