# Insect Population Control

Field biologists run a field experiment over $n$ days to assess the
population of an invasor insect species.

An insect trap is set on the first day, and a new trap is added every
day, so on the $i$th day, $i$ traps are deployed. Each trap is expected
to capture $K$ individuals. However, specimens learn to avoid traps, so
the effectiveness of the traps decays with time.

For this, the expected number of captured individuals on the $i$-th day
is: $$E_i = \frac{K*i}{i!}$$ Thus, the accumulated number of captures
after $n$ days of field work will be:
$$C(n) = \sum_{i=1}^{n}\frac{K*i}{i!}$$

Write a function `captures(n,K)` that receives two integers: the number
of days of the field experiment ($n$) and the expected captures per trap
($K$) and returns the expected accumulated number of captures $C(n)$ at
the end of the field experiment.

## Observation

- You are not allowed to import any function from `math` module.

- Using lists is not necessary, and will severely penalize your grade.

- Only the function is expected. If you have a main program to test it,
  comment it out, or put it inside an `if __name__ == "__main__":`
  conditional.

## Problem information

Author: Lluís Padró

Generation: 2026-01-25T12:57:16.870Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
