# Trobar el valor més proper a un valor donat

Implementa una funció **RECURSIVA** que, donat un arbre binari no buit
d'enters i un enter *x* retorni el valor de l'arbre que està més proper
a *x*. En cas que hi hagi dos valors que estan igual d'aprop a *x* s'ha
de tornar el valor més petit.

La capçalera de la funció que has d'implementar és la següent:

``` c++
// \textbf{Pre}:  t no és buit
// \textbf{Post}: Torna el valor de \emph{t} que és més proper a \emph{x}. En cas que hi hagi dos valors 
// igual de propers es torna el menor d'ells.
int mes_proper(const BinaryTree<int> &t, int x);
```

Exemple:

Donat el següent arbre binari, les següents crides a la funció
tornarien:

            1                          
            |                                  
             ----                               
                 |                                  
                 5                     
                 |                                  
          ------- -------                   
         |               |                  
         6               1             
         |               |                 
     ---- ----       ---- ----         
    |         |     |         |        
    3         8     9         7        
                    |                   
                     ----               
                         |              
                         8             

    mes_proper( 1(,5(6(3,8),1(9(,8),7))), 15 ) =  9
    mes_proper( 1(,5(6(3,8),1(9(,8),7))), 2 ) =  1
    mes_proper( 1(,5(6(3,8),1(9(,8),7))), 5 ) =  5

Fixa't que l'enunciat d'aquest exercici ja ofereix uns fitxers que has
d'utilitzar per a compilar: `Makefile`, `program.cpp`, `BinaryTree.hpp`,
`mes_proper.hpp`. Només cal que creïs `mes_proper.cpp`, posant-hi els
includes que calguin i implementant la funció `mes_proper`. I quan pugis
la teva solució al jutge, només cal que pugis un tar construït així:

    tar cf solution.tar mes_proper.cpp

## Entrada

La primera línia de l'entrada descriu el format en el que es descriuen
els arbres, o bé INLINEFORMAT o bé VISUALFORMAT. Després venen un nombre
arbitrari de casos. Cada cas consisteix en una descripció d'un arbre
binari d'enters i un enter. Fixa't que el programa que t'oferim ja
s'encarrega de llegir aquestes entrades. **Només cal que implementis la
funció abans esmentada**.

## Sortida

Per a cada cas, cal escriure el resultat de cridar a la funció abans
esmentada amb l'arbre d'entrada. Fixa't que el programa que t'oferim ja
s'encarrega d'escriure aquesta sortida. **Només cal que implementis la
funció abans esmentada**.

## Observació

La teva funció i subfuncions que creïs han de treballar només amb arbres
binaris. Has de trobar una solució **RECURSIVA** del problema. En les
crides recursives, inclou tant la **Hipòtesi d'inducció** com la
**funció de fita/decreixement** de cada crida recursiva.

## Informació del problema

Autoria: Bernardino Casas

Generació: 2026-01-25T20:34:50.270Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
