# Comprimir matriu dispersa

Una matriu es considera **dispersa** si més del 70% dels seus elements
són zeros.

Per tal que la matriu ocupi menys espai s'ha pensat en comprimir les
matrius disperses. El format comprimit d'una matriu consisteix en una
llista de tuples o triples dels elements diferents de zero de la forma:
$(x, y, v)$ on:

- *x* és l'índex de la fila (començant per 0).

- *y* és l'índex de la columna (començant per 0).

- *v* és el valor de l'element a la posició $(x, y)$ .

A més el primer element d'aquest llistat indica la mida de la matriu.

Suposem que tenim la matriu següent: $$\begin{bmatrix}
	0 & 0 & 3 & 0 & 0 \\
	0 & 5 & 0 & 0 & 0 \\
	0 & 0 & 0 & 0 & 1\\
	7 & 0 & 0 & 0 & 0\\
\end{bmatrix}$$

la versió comprimida de la matriu seria:

    [ <4,5,0>, <0,2,3>, <1,1,5>, <2,4,1>, <3,0,7> ]

Escriu un programa que llegeixi una seqüència de matrius d'enters no
buides i faci un estudi de compressió de cada matriu. El programa ha de
mostrar per cada matriu:

1.  Si la matriu donada és dispersa o no.

2.  La versió comprimida de la matriu seguint el format indicat
    anteriorment.

3.  El nombre d'enters que té la matriu i el nombre d'enters que ocupa
    la versió comprimida de la matriu.

**[IMPORTANT!]{style="color: red"}** Has d'implementar i usar la funció
`comprimir` que, donada una matriu d'enters torna un vector amb la
matriu comprimida.

    void comprimir(const vector<vector<int>> &mat, vector<Casella> &compr);

El tipus `Casella` és el següent:

    struct Casella {
    	int fil;
    	int col;
    	int valor;
    };

## Entrada

L'entrada consisteix en una seqüència de matrius d'enters. Cada matriu
es defineix com:

- dos naturals indicant les dimensions de la matriu.

- els valors de la matriu.

## Sortida

Mostra per cada matriu de la seqüència les següents línies:

- La paraula \"Matriu\" i el número de la matriu d'entrada seguit de
  \":\"

- La cadena de caràcters \"DISPERSA\" si la matriu és dispersa i \"NO
  DISPERSA\" si no ho és.

- La paraula \"Matriu\" i el número de la matriu d'entrada seguit de \"
  comprimida:\"

- La versió comprimida de la matriu el format de la qual es pot veure en
  l'exemple anterior.

- El nombre d'enters que té la matriu i el nombre d'enters que ocupa la
  versió comprimida de la matriu.

Per obtenir més detalls sobre la sortida consulta els jocs de proves
públics.

## Informació del problema

Autoria: Bernardino Casas

Generació: 2026-01-25T12:55:12.956Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
