# Generació del Codi de Luhn

El codi de Luhn és un algorisme de validació utilitzat en números de
targetes de crèdit i altres identificadors. Aquest algorisme permet
detectar errors en la introducció de números mitjançant una suma de
verificació. És a dir, l'algorisme genera un dígit que permet verificar
que el nombre és correcte.

Per calcular el dígit de control cal seguir aquests passos:

1.  Processa els dígits des de la dreta cap a l'esquerra.

2.  Duplica els dígits en posicions senars (comptant des de la dreta,
    començant per 1). Si el resultat de la duplicació és major que 9,
    suma els seus dígits (per exemple,
    $8 \cdot 2 = 16 \longrightarrow 1 + 6 = 7$).

3.  Suma tots els dígits resultants.

4.  Calcula el dígit de verificació com la xifra que cal afegir perquè
    la suma sigui múltiple de 10.

Per exemple, el codi de Luhn del nombre 739875 es calcularia com:

::: center
  --- ---- ------ ---- --- ---- ------ ---- --- ---- ------ ----------
   7         3          9         8          7         5    
   7        3\*2        9        8\*2        7        5\*2  
             6                    16                   10   
                                  7                    1    
   7   \+    6     \+   9   \+    7     \+   7   \+    1     = **37**
  --- ---- ------ ---- --- ---- ------ ---- --- ---- ------ ----------
:::

El codi Luhn seria la quantitat que falta per tal que 37 sigui múltiple
de 10, és a dir, 3.

Se't demana implementar un programa que llegeixi un flux de naturals
acabat en 0, calculi el dígit de control segons l'algorisme de Luhn per
a cadascun dels números i imprimeixi cada número original amb el seu
dígit de verificació afegit.

[**IMPORTANT!**]{style="color: red"}: Per resoldre aquest problema cal
que implementis la **funció** \@codi_luhn@ que donat un nombre natural
retorna el codi de Luhn d'aquest nombre.

## Entrada

L'entrada consisteix en un flux de naturals acabat en `0`.

## Sortida

Mostra cada número del flux amb el seu dígit de verificació afegit.

## Observació

Per resoldre aquest exercici no es poden usar variables strings, taules
ni vectors.

## Informació del problema

Autoria: Bernardino Casas

Generació: 2026-01-25T12:52:53.859Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
