# Conecta 4

El **Conecta 4** es un juego de tablero para dos jugadores. El tablero
tiene un número de filas y columnas (típicamente 6 filas y 7 columnas).
Cada jugador tiene fichas de un color (representadas por 1 y 2). Los
jugadores van tirando fichas alternativamente a una columna, y la ficha
cae hasta la posición más baja disponible de esa columna (como si
hubiera gravedad).

Por ejemplo, si tenemos un tablero vacío de 6 filas y 7 columnas y los
jugadores hacen las tiradas siguientes:

    Columna 0, Jugador 1
    Columna 1, Jugador 2
    Columna 2, Jugador 1
    Columna 0, Jugador 2
    Columna 1, Jugador 1
    Columna 1, Jugador 2
    Columna 0, Jugador 1

El tablero resultante sería:

    0000000
    0000000
    0000000
    1000000
    2120000
    1210000

Donde 0 indica una casilla vacía, 1 indica una ficha del jugador 1, y 2
indica una ficha del jugador 2.

Disponemos de los tipos siguientes:

    #include <vector>
    using namespace std;

    typedef vector<int> Fila;
    typedef vector<Fila> Taulell;

    struct Tirada {
        int col;
        int fitxa;  // 1 o 2
    };

    /**
     * @brief Ejecuta una secuencia de tiradas sobre un tablero.
     *        Cada tirada consiste en dejar caer una ficha en una columna.
     *        La ficha cae hasta la posición más baja disponible.
     *        Si la columna está llena, la tirada se ignora.
     *
     * @param T El tablero de juego (se modifica)
     * @param tirades El vector de tiradas a ejecutar
     * @pre Para cada tirada t en tirades: 0 <= t.col < T[0].size() y t.fitxa es 1 o 2.
     */
    void executa_tirades(Taulell& T, const vector<Tirada>& tirades);

Implementa la función `executa_tirades` con la declaración de arriba.

## Observación

El centro de interés de este problema es la *corrección*. Los casos de
prueba comprueban que la mayoría de casos posibles produzcan la salida
correcta.

**IMPORTANTE**: Al enviar este problema, hay que poner en el fichero
`.cc` solo la función `executa_tirades` (y las funciones auxiliares que
necesitéis) con los includes necesarios y los `typedef` y `struct`
dados. Hay que borrar (o comentar con `/*` y `*/`) la función `main` y
las otras funciones del `main.cc` proporcionado.

## Entrada

*La entrada ya la hace el programa principal proporcionado*. Consiste en
varios casos. Cada caso empieza con tres enteros: el número de filas, el
número de columnas, y el número de tiradas. Después vienen las tiradas,
cada una con dos enteros: la columna y el número de ficha (1 o 2).

## Salida

*La salida también la produce el programa principal proporcionado*. Para
cada caso, se muestra el tablero resultante, con una línea por fila,
donde cada casilla es 0 (vacía), 1 (ficha del jugador 1) o 2 (ficha del
jugador 2). Entre cada tablero hay una línea en blanco.

## Información del problema

Autoría: Unknown\
Traducción: Pau Fernández

Generación: 2026-02-03T07:39:50.456Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
