#include <iostream>
#include <vector>
using namespace std;

/*  --> Descomenteu aquestes declaracions per poder compilar <--
typedef vector<int> Fila;
typedef vector<Fila> Taulell;

struct Tirada {
	int col;
	int fitxa;	// 1 o 2
};
*/

/**
 * @brief Executa una seqüència de tirades sobre un taulell.
 *        Cada tirada consisteix en deixar caure una fitxa a una columna.
 *        La fitxa cau fins a la posició més baixa disponible.
 *        Si la columna està plena, la tirada s'ignora.
 *
 * @param T El taulell de joc (es modifica)
 * @param tirades El vector de tirades a executar
 * @pre Per a cada tirada t en tirades: 0 <= t.col < T[0].size() i t.fitxa és 1 o 2.
 */
void executa_tirades(Taulell& T, const vector<Tirada>& tirades);

void mostra_taulell(const Taulell& T) {
	int FILES = T.size(), COLS = T[0].size();
	for (int i = 0; i < FILES; i++) {
		for (int j = 0; j < COLS; j++) {
			cout << T[i][j];
		}
		cout << endl;
	}
	cout << endl;
}

vector<Tirada> llegeix_tirades(int n) {
	vector<Tirada> tirades(n);
	for (int i = 0; i < n; i++) {
		cin >> tirades[i].col >> tirades[i].fitxa;
	}
	return tirades;
}

int main() {
	int files, columnes, ntirades;
	while (cin >> files >> columnes >> ntirades) {
		vector<Tirada> tirades = llegeix_tirades(ntirades);
		Taulell T(files, Fila(columnes));
		executa_tirades(T, tirades);
		mostra_taulell(T);
	}
}