# Connecta 4

El **Connecta 4** és un joc de tauler per a dos jugadors. El tauler té
un nombre de files i columnes (típicament 6 files i 7 columnes). Cada
jugador té fitxes d'un color (representades per 1 i 2). Els jugadors van
tirant fitxes alternativament a una columna, i la fitxa cau fins a la
posició més baixa disponible d'aquella columna (com si hi hagués
gravetat).

Per exemple, si tenim un tauler buit de 6 files i 7 columnes i els
jugadors fan les tirades següents:

    Columna 0, Jugador 1
    Columna 1, Jugador 2
    Columna 2, Jugador 1
    Columna 0, Jugador 2
    Columna 1, Jugador 1
    Columna 1, Jugador 2
    Columna 0, Jugador 1

El tauler resultant seria:

    0000000
    0000000
    0000000
    1000000
    2120000
    1210000

A on 0 indica una casella buida, 1 indica una fitxa del jugador 1, i 2
indica una fitxa del jugador 2.

Disposem dels tipus següents:

    #include <vector>
    using namespace std;

    typedef vector<int> Fila;
    typedef vector<Fila> Taulell;

    struct Tirada {
        int col;
        int fitxa;  // 1 o 2
    };

    /**
     * @brief Executa una seqüència de tirades sobre un taulell.
     *        Cada tirada consisteix en deixar caure una fitxa a una columna.
     *        La fitxa cau fins a la posició més baixa disponible.
     *        Si la columna està plena, la tirada s'ignora.
     *
     * @param T El taulell de joc (es modifica)
     * @param tirades El vector de tirades a executar
     * @pre Per a cada tirada t en tirades: 0 <= t.col < T[0].size() i t.fitxa és 1 o 2.
     */
    void executa_tirades(Taulell& T, const vector<Tirada>& tirades);

Implementa la funció `executa_tirades` amb la declaració de dalt.

## Observació

El centre d'interès d'aquest problema és la *correctesa*. Els jocs de
prova comproven que la majoria de casos possibles produeixin la sortida
correcta.

**IMPORTANT**: Quan envieu aquest problema, cal posar en el fitxer `.cc`
només la funció `executa_tirades` (i les funcions auxiliars que
necessiteu) amb els includes necessaris i els `typedef` i `struct`
donats. Cal esborrar (o comentar amb `/*` i `*/`) la funció `main` i les
altres funcions del `main.cc` proporcionat.

## Entrada

*L'entrada ja la fa el programa principal proporcionat*. Consisteix en
un seguit de casos. Cada cas comença amb tres enters: el nombre de
files, el nombre de columnes, i el nombre de tirades. Després venen les
tirades, cadascuna amb dos enters: la columna i el número de fitxa (1 o
2).

## Sortida

*La sortida també la produeix el programa principal proporcionat*. Per a
cada cas, es mostra el taulell resultant, amb una línia per fila, on
cada casella és 0 (buida), 1 (fitxa del jugador 1) o 2 (fitxa del
jugador 2). Entre cada taulell hi ha una línia en blanc.

## Informació del problema

Autoria: Pau Fernández

Generació: 2026-02-03T07:39:45.936Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
