#--------------------------------------------------------------------------

from pytokr import item

def leer_arbolbinario_int():
    x = int(item())
    if x != -1:  # suponemos que la marca es -1
        l = leer_arbolbinario_int()
        r = leer_arbolbinario_int()
        return ArbreBinari(x,l,r)
    else:
        return ArbreBinari()

#--------------------------------------------------------------------------

# La clase Arbre Binari que ya hemos visto en la sesión 6 de laboratorio.
# Hemos eliminado algunos métodos que no vamos a necesitar (nivells y __repr__).

class ArbreBinari:

    def __init__(self,v=None,esq=None,dre=None):
        """
        Al tanto! un arbre binari buit NO és None
        Un arbre buit és un ArbreBinari amb self._root igual a None
        L'objecte creat per una crida a ArbreBinari() és un arbre buit.
        Si el valor de v és None, també ho han de ser esq i dre.
        """
        assert (v is None and esq is None and dre is None) or v is not None
        if v is None:
            self._root = None
        else:
            fesq  = esq if esq is not None else ArbreBinari()
            fdre  = dre if dre is not None else ArbreBinari()
            self._root = {"v": v, "fesq": fesq, "fdre": fdre}
            
    # Getters
    def valor_arrel(self):
        """
        Pre: Suposem que self no és buit
        retorna el valor a l'arrel de self
        """
        return self._root["v"]
    
    def fill_esq(self):
        """
        Pre: Suposem que self no és buit
        retorna un ArbreBinari que representa el fill esquerre de self
        """
        return self._root["fesq"]
    
    def fill_dre(self):
        """
        Pre: Suposem que self no és buit
        retorna un ArbreBinari que representa el fill dret de self
        """
        return self._root["fdre"]

    # Setters
    def modificar_valor_arrel(self,v):
        """
        canvia el valor a l'arrel de self. Aquest nou valor no pot ser None
        """
        assert(v is not None)
        if not self.buit():
            self._root["v"] = v
        else:
            self._root =  {"v": v, "fesq": ArbreBinari(), "fdre": ArbreBinari()}
        
    def modificar_fill_esq(self,esq):
        """
        Pre: esq és un ArbreBinari i self no és buit
        canvia el fill esquerre de self
        """
        self._root["fesq"] = esq
        
    def modificar_fill_dre(self,dre):
        """
        Pre: dre és un ArbreBinari i self no és buit
        canvia el fill dret de self
        """
        self._root["fdre"] = dre
        
    # Altres operacions
    def buit(self):
        """
        retorna True si self és buit, False en altre cas
        """
        return self._root == None
        
    def fulla(self):
        """
        retorna True si self és una fulla, False en altre cas
        """
        if self.buit():
            return False
        return self.fill_esq().buit() and self.fill_dre().buit()

    # Recorreguts 
    def preordre(self):
        """
        retorna una llista amb els elements de self, ordenats d'acord a la definició 
        del recorregut en preordre
        """
        if self.buit():
            return []
        else:
            return [self.valor_arrel()] + self.fill_esq().preordre() + self.fill_dre().preordre()

    def postordre(self):
        """
        retorna una llista amb els elements de self, ordenats d'acord a la definició 
        del recorregut en postordre
        """
        if self.buit():
            return []
        else:
            return self.fill_esq().postordre() + self.fill_dre().postordre() + [self.valor_arrel()]
        
    def inordre(self):
        """
        retorna una llista amb els elements de self, ordenats d'acord a la definició 
        del recorregut en inordre
        """
        if self.buit():
            return []
        else:
            return self.fill_esq().inordre() + [self.valor_arrel()] + self.fill_dre().inordre()

#--------------------------------------------------------------------------

def escorar(a):
    """
    Pre: a es una instancia de ArbreBinari, con números positivos en los nodos (si a no está vacío)
    Esta función es una operación NO destructiva (no modifica a)
    Retorna: El árbol escorado, el peso (suma del valor en los nodos) y el tamaño (número de nodos)
    """
    # Aquí se ha de escribir el código de su solución al problema
        
#--------------------------------------------------------------------------

a = leer_arbolbinario_int()
a_escorado, _, _   = escorar(a)
preorden_escorado  = a_escorado.preordre()
inorden_escorado   = a_escorado.inordre()
print(','.join(list(map(str,preorden_escorado))))
print(','.join(list(map(str,inorden_escorado))))
