#--------------------------------------------------------------------------

from pytokr import item

def llegeix_arbrebinari_int():
    x = int(item())
    if x != -1:  # suposem que la marca és -1
        l = llegeix_arbrebinari_int()
        r = llegeix_arbrebinari_int()
        return ArbreBinari(x,l,r)
    else:
        return ArbreBinari()

#--------------------------------------------------------------------------

# La classe Arbre Binari que vam veure a la sessió 6 de laboratori.
# Li hem tret alguns mètodes que segur que no fan falta (nivells i __repr__).

class ArbreBinari:

    def __init__(self,v=None,esq=None,dre=None):
        """
        Al tanto! un arbre binari buit NO és None
        Un arbre buit és un ArbreBinari amb self._root igual a None
        L'objecte creat per una crida a ArbreBinari() és un arbre buit.
        Si el valor de v és None, també ho han de ser esq i dre.
        """
        assert (v is None and esq is None and dre is None) or v is not None
        if v is None:
            self._root = None
        else:
            fesq  = esq if esq is not None else ArbreBinari()
            fdre  = dre if dre is not None else ArbreBinari()
            self._root = {"v": v, "fesq": fesq, "fdre": fdre}
            
    # Getters
    def valor_arrel(self):
        """
        Pre: Suposem que self no és buit
        retorna el valor a l'arrel de self
        """
        return self._root["v"]
    
    def fill_esq(self):
        """
        Pre: Suposem que self no és buit
        retorna un ArbreBinari que representa el fill esquerre de self
        """
        return self._root["fesq"]
    
    def fill_dre(self):
        """
        Pre: Suposem que self no és buit
        retorna un ArbreBinari que representa el fill dret de self
        """
        return self._root["fdre"]

    # Setters
    def modificar_valor_arrel(self,v):
        """
        canvia el valor a l'arrel de self. Aquest nou valor no pot ser None
        """
        assert(v is not None)
        if not self.buit():
            self._root["v"] = v
        else:
            self._root =  {"v": v, "fesq": ArbreBinari(), "fdre": ArbreBinari()}
        
    def modificar_fill_esq(self,esq):
        """
        Pre: esq és un ArbreBinari i self no és buit
        canvia el fill esquerre de self
        """
        self._root["fesq"] = esq
        
    def modificar_fill_dre(self,dre):
        """
        Pre: dre és un ArbreBinari i self no és buit
        canvia el fill dret de self
        """
        self._root["fdre"] = dre
        
    # Altres operacions
    def buit(self):
        """
        retorna True si self és buit, False en altre cas
        """
        return self._root == None
        
    def fulla(self):
        """
        retorna True si self és una fulla, False en altre cas
        """
        if self.buit():
            return False
        return self.fill_esq().buit() and self.fill_dre().buit()

    # Recorreguts 
    def preordre(self):
        """
        retorna una llista amb els elements de self, ordenats d'acord a la definició 
        del recorregut en preordre
        """
        if self.buit():
            return []
        else:
            return [self.valor_arrel()] + self.fill_esq().preordre() + self.fill_dre().preordre()

    def postordre(self):
        """
        retorna una llista amb els elements de self, ordenats d'acord a la definició 
        del recorregut en postordre
        """
        if self.buit():
            return []
        else:
            return self.fill_esq().postordre() + self.fill_dre().postordre() + [self.valor_arrel()]
        
    def inordre(self):
        """
        retorna una llista amb els elements de self, ordenats d'acord a la definició 
        del recorregut en inordre
        """
        if self.buit():
            return []
        else:
            return self.fill_esq().inordre() + [self.valor_arrel()] + self.fill_dre().inordre()

#--------------------------------------------------------------------------

def escorar(a):
    """
    Pre: a és una instància d'ArbreBinari, amb nombres positius als nodes (si a no és buit)
    Aquesta funció és una operació NO destructiva (no modifica a)
    Retorna: L'arbre escorat, el pes (suma del valor en els nodes) i la mida (nombre de nodes)
    """
    # Aquí heu d'escriure el codi de la vostra solució al problema 
        
#--------------------------------------------------------------------------

a = llegeix_arbrebinari_int()
a_escorat, _, _   = escorar(a)
preordre_escorat  = a_escorat.preordre()
inordre_escorat   = a_escorat.inordre()
print(','.join(list(map(str,preordre_escorat))))
print(','.join(list(map(str,inordre_escorat))))
