# Plega Matriz

Sea $M$ una matriz cuadrada $2N \times 2N$. El **plegado** de una matriz
consiste en plegar la matriz de enteros primero por la línea horizontal
que divide la matriz, y después por la línea vertical.

Por ejemplo, sea la siguiente matriz con cuatro cuadrantes $A,B,C,D$, el
plegado hace que la parte superior ($A,B$) se superponga con la parte
inferior ($C,D$), y el segundo plegado hace que la parte de la derecha
($B,D$) se superponga con la de la izquierda (A,C).

::: center
               =============        =============      ===========
               |     |     |        |     |     |      |         |                
               |  A  |  B  |   ==>  | A,C | B,D |  ==> | A,B,C,D |
               |     |     |        |     |     |      |         |        
    plego -->  -------------        -------------      -----------     
               |     |     |              ^
               |  C  |  D  |              |
               |     |     |              |
               =============            plego
:::

Fíjese que en este caso, la matriz pasa de ser de $2N \times 2N$ a una
matriz $N \times N$ en la que cada posición tiene 4 números de la matriz
original **superpuestos**.

El siguiente ejemplo muestra qué posiciones se superponen con otras
según su número. Esto significa que todas las cuatro posiciones que
tienen el número $1$ se superponen, las que tienen el número $2$
también, etc.

                              <---- 2N ------>
                              ################  ^
                              # 1  2  | 2  1 #  |
                              # 3  4  | 4  3 #  |
                              #--------------#  2N
                              # 3  4  | 4  3 #  |
                              # 1  2  | 2  1 #  |
                              ################  v

Es necesario implementar la acción
`void plegaMatriu(const Matriu& m, Matriu& r)` con la siguiente
especificación:

`PRE: ` $m$ una matriz $2N \times 2N$ de enteros.

`POST:` $r$ es una matriz $N \times N$ en la que en cada posición tiene
la **suma** de los elementos de $m$ superpuestos por el **plegado** de
$m$.

## Observación

**IMPORTANTE:** Sólo hay que enviar la acción que se pide, y quizás
otras acciones y funciones necesarias. Hay que mantener, sin embargo,
las definiciones de tipos y los `#include`s.

## Entrada

Una matriz $2N \times 2N$.

## Salida

Una matriz $N \times N$ en la que en cada posición tiene la **suma** de
los elementos de $m$ superpuestos por el **plegado** de $m$.

## Información del problema

Autoría: PRO1

Generación: 2026-01-25T12:51:58.425Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
