# Ordena un Vector R

Un **vector R** es un vector que está compuesto de dos partes:

$$v = x_1 ~ x_2 ~ x_3 ~ x_4 \dots x_n ~ y_1 ~ y_2~ y_3 \dots y_m$$

tales que la parte $x_1 \dots x_n$ y la parte $y_1 \dots y_m$ están
ordenadas de forma estrictamente creciente pero $y_m < x_1$. Además
tenemos $n,m > 0$. Es decir, ninguna de las dos partes está vacía.

Es necesario implementar la **función**
`void ordena(vector<int>& v, int pos)` con la siguiente especificación:

`PRE:` $v$ es un vector R como $\mid \! v \! \mid \geq 3$, y $pos$ es la
posición en la que se encuentra $y_1$ en $v$.

`POST:` El vector $v$ está ordenado.

## Observación

Sólo tiene que enviar la función que le pedimos y las acciones y
funciones que vosotros mismos defina. El resto no se tendrá en cuenta.

No se puede utilizar la operación `sort` de la biblioteca `stl`.

Pista: saber la posición en la que se encuentra $y_1$ le puede ayudar a
ordenar el vector en tiempo lineal.

Por otra parte, si utiliza un vector auxiliar para realizar la
ordenación tendrá una penalización de $-5$ en la corrección manual
aunque tenga un semáforo verde.

## Entrada

Un número indeterminado de vectores R con el siguiente formato: un
entero que indica su tamaño, después el vector R y finalmente la
posición en la que se encuentra $y_1$. Todo vector R tiene un tamaño
mayor o igual a 3.

## Salida

El vector $v$ ordenado.

## Información del problema

Autoría: PRO1

Generación: 2026-01-25T12:49:51.719Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
