# Cerca en un arbre binari de parelles

Implementa la funció:

    /**
     * @brief Cerca l'enter d'un `pair<int, string>` en un arbre binari i
     *        retorna el `string` associat a aquest enter.
     *
     * @param t Arbre binari de parelles d'enters i `string`s.
     * @param x Valor a cercar.
     * @param trobat Paràmetre de sortida amb l'`string` associat a `x`.
     *
     * @returns `true` si `x` és el `first` d'algun parell a `t`,
     *          `false` en cas contrari.
     *
     * @post Si el resultat és `true`, `trobat` conté l'`string` associat a `x`.
     */
    bool find_first(BinTree<pair<int, string>> t, int x, string& trobat);    

## Observació

Els fitxers públics (icona del gatet) són: la classe `BinTree` (fitxer
`bintree.hh`), l'entrada/sortida de `BinTree` (`bintree-io.hh`) i el
programa principal. També hi ha un `Makefile` i el directori `.vscode`
que té la configuració per compilar i debuggar amb VSCode.

Has d'implementar `find_first` en un **fitxer `.cc` nou**, compilar
(està preparat per poder compilar i debuggar amb VSCode), i finalment
**enviar només el fitxer amb la funció**.

Els exemples d'entrada/sortida mostren que el `main` que utilitza el
Jutge llegeix un arbre de parells i tot seguit una seqüència d'enters a
cercar i, per a cadascún, crida la funció `find_first`, mostrant el
resultat de la cerca. (Per tant, no cal implementar-lo.)

## Informació del problema

Autoria: Pau Fernández

Generació: 2026-01-25T12:47:36.540Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
