#ifndef INTERVAL_HH
#define INTERVAL_HH

#include <string>
#include <cassert>

struct Interval {
    std::string id;  // Identificador únic
    int begin, end;  // Coordenades d'inici i final de l'interval
};

/**
 * Operador de comparació de `Range`s, per poder-los utilitzar en un `set`.
 */
inline bool operator<(const Interval& a, const Interval& b) {
    return a.id < b.id;
}

inline bool intersects(int begin, int end, const Interval& interval) {
    assert(begin <= end && interval.begin <= interval.end);
    return !(end < interval.begin || begin > interval.end);
}

#endif
