
#include <cassert>
#include <iostream>
#include <set>
#include <unordered_map>
using namespace std;

#include "interval-finder.hh"

Interval read_interval() {
    Interval r;
    cin >> r.id >> r.begin >> r.end;
    return r;
}

pair<int, int> read_begin_end() {
    int begin, end;
    cin >> begin >> end;
    return {begin, end};
}

int main() {
    IntervalFinder *finder = new IntervalFinder();

    char cmd;
    while (cin >> cmd) {
        switch (cmd) {
            case '+': {  // add
                auto ival = read_interval();
                finder->add(ival);
                break;
            }
            case '?': {  // query
                auto pair = read_begin_end();
                auto result = finder->query(pair.first, pair.second);
                if (result.empty()) {
                    cout << "empty" << endl;
                } else {
                    cout << "ids:";
                    for (auto id : result) {
                        cout << ' ' << id;
                    }
                    cout << endl;
                }
                break;
            }
            case '0': {  // reset
                delete finder;
                finder = new IntervalFinder();
                break;
            }
        }
    }

    return 0;
}