# Fusió de llistes ordenades

Fes la funció següent, que fusiona dues llistes de fruites en **ordre
descendent**:

    /**
     * @brief Fusiona dues llistes ordenades preservant l'ordre.
     * 
     * @param a Llista en ordre descendent.
     * @param b Llista en ordre descendent.
     * 
     * @return Llista en ordre descendent amb els elements d'a i b.
     */
    list<Fruit> fusio_ordenada(const list<Fruit>& a, const list<Fruit>& b);

Una fruita va abans que una altra quan el seu preu és major, i si el
preu és el mateix, quan el nom és lexicogràficament anterior. La
comparació entre dues fruites la implementa ja el mètode
`is_greater_than` que surt a continuació. La declaració sencera de la
classe `Fruit` és la següent:

    class Fruit {
     public:
           Fruit(string name, int price); // Construeix una fruita

    string name()  const; // retorna el nom
       int price() const; // retorna el preu

        // Determina si una fruita té un preu major o si amb el mateix 
        // preu, el nom és anterior a `other`
      bool is_greater_than(const Fruit& other) const; 
    };    

## Observació

Els fitxers públics (icona del gatet) contenen:

  ------------ ----------------------------------------------------
  `main.cc`    el programa principal, amb la entrada/sortida feta
  `fruit.hh`   la classe `Fruit`, amb els mètodes esmentats
  `Makefile`   per compilar amb `make` còmodament
  `.vscode`    carpeta per compilar i debuggar amb VSCode
  ------------ ----------------------------------------------------

## Entrada

La funció rep dues llistes de fruites no modificables, ordenades
descendentment. (De la lectura de les llistes, que estan separades per
una línia buida, ja se n'encarrega el programa principal.)

## Sortida

La funció retorna la llista resultant de fusionar les dues llistes
preservant l'ordre original. (De l'escriptura de la llista resultant
també se n'encarrega el programa principal.)

## Informació del problema

Autoria: Pau Fernández

Generació: 2026-01-25T12:42:48.160Z

© *Jutge.org*, 2006--2026.\
<https://jutge.org>
